import 'package:country_picker/country_picker.dart';
import 'package:get/get.dart';

import '../utils/all_imports.dart';

//ignore: must_be_immutable
class CommonTextFiled extends StatefulWidget {
  final TextEditingController? controller;
  final Function(String)? onChanged;
  final String? hintText;
  final String? prefixIcon;
  bool? readOnly;

  String title;
  final int? maxLength;

  bool isTitle;
  final GestureTapCallback? onSuffixTap;
  bool enableInteractiveSelection;
  final Widget? suffixIcon;
  final bool isMaxLines;
  final int? maxLines;
  final Color? titleColor;
  Rx<Country>? selectCounty;

  final FontWeight? titleFontWeight;
  final TextInputAction? textInputAction;
  TextCapitalization? textCapitalization;
  final TextInputType? inputType;
  bool enabled;
  bool obscureText;
  bool suffixVisibility;
  final List<TextInputFormatter>? inputFormat;

  CommonTextFiled({
    super.key,
    this.inputType,
    this.controller,
    this.suffixIcon,
    this.prefixIcon,
    this.maxLength,
    this.enableInteractiveSelection = true,
    this.onChanged,
    this.selectCounty,
    this.isMaxLines = false,
    this.readOnly,
    this.inputFormat,
    this.maxLines,
    this.hintText,
    this.textCapitalization,
    this.obscureText = true,
    this.suffixVisibility = false,
    this.enabled = true,
    this.textInputAction = TextInputAction.next,
    this.titleColor = AppColors.darkBlueText,
    this.title = "",
    this.isTitle = true,
    this.onSuffixTap,
    this.titleFontWeight = FontWeight.w500,
  });

  @override
  State<CommonTextFiled> createState() => _CommonTextFiledState();
}

class _CommonTextFiledState extends State<CommonTextFiled> {
  toggle() {
    setState(() {
      widget.obscureText = !widget.obscureText;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Visibility(
          visible: widget.isTitle,
          child: AppText(
            widget.title,
            textAlign: TextAlign.center,
            color: widget.titleColor ?? AppColors.black,
            fontFamily: FontFamily.montserratSemiBold,
            fontWeight: widget.titleFontWeight ?? FontWeight.w600,
            fontSize: 16.sp,
          ),
        ),
        Visibility(visible: widget.isTitle, child: SizedBox(height: 10.h)),
        TextFormField(
          controller: widget.controller,
          onTapOutside: (val) {},
          keyboardType: widget.inputType,
          onChanged: widget.onChanged,
          maxLength: widget.maxLength,
          obscureText: !widget.obscureText,
          textInputAction: widget.textInputAction,
          enableInteractiveSelection: widget.enableInteractiveSelection,
          maxLines: /*widget.isMaxLines ? widget.maxLines : null*/ 1,
          textCapitalization: widget.textCapitalization ?? TextCapitalization.none,
          enabled: widget.enabled,
          inputFormatters: widget.inputFormat,
          readOnly: widget.readOnly ?? false,
          style: TextStyle(color: AppColors.darkBlueText, fontFamily: FontFamily.montserratSemiBold, fontSize: 16.sp, fontWeight: FontWeight.w600),
          decoration: InputDecoration(
            hintText: widget.hintText ?? "",
            prefixIcon: widget.prefixIcon == null
                ? null
                : Padding(
                    padding: EdgeInsets.only(left: 15.w, right: 10.w),
                    child: (widget.selectCounty != null)
                        ? IgnorePointer(
                            ignoring: (widget.readOnly ?? false),
                            child: Row(
                              mainAxisSize: MainAxisSize.min,
                              children: [
                                Image.asset(
                                  widget.prefixIcon!,
                                  height: 24.h,
                                  width: 24.w,
                                ),
                                SizedBox(width: 10.sp),
                                GestureDetector(
                                  onTap: () {
                                    showCountryPicker(
                                      context: context,
                                      showPhoneCode: true,
                                      onSelect: (Country country) {
                                        widget.selectCounty!.value = country;
                                      },
                                    );
                                  },
                                  child: Obx(() {
                                    return AppText(
                                      "${widget.selectCounty!.value.flagEmoji}  +${widget.selectCounty!.value.phoneCode}",
                                      fontSize: 18.sp,
                                      color: AppColors.black,
                                      fontFamily: FontFamily.montserratMedium,
                                    );
                                  }),
                                ),
                              ],
                            ),
                          )
                        : Image.asset(
                            widget.prefixIcon!,
                            height: 24.h,
                            width: 24.w,
                          ),
                  ),
            suffixIcon: !widget.suffixVisibility
                ? widget.suffixIcon
                : Visibility(
                    visible: widget.suffixVisibility,
                    child: GestureDetector(
                      onTap: toggle,
                      child: Container(
                        margin: EdgeInsets.all(14.sp),
                        child: Image.asset(
                          !widget.obscureText ? AppImages.eyeSlash : AppImages.eye,
                          height: 24.h,
                          width: 24.w,
                        ),
                      ),
                    ),
                  ),
            hintStyle: TextStyle(
              color: AppColors.darkBlue400,
              fontFamily: FontFamily.montserratMedium,
              fontSize: 16.sp,
              fontWeight: FontWeight.w500,
            ),
            labelStyle: TextStyle(
              color: AppColors.darkBlueText,
              fontFamily: FontFamily.montserratSemiBold,
              fontSize: 16.sp,
              fontWeight: FontWeight.w500,
            ),
            contentPadding: EdgeInsets.symmetric(vertical: 14.h, horizontal: widget.prefixIcon == null ? 15.w : 2.w),
            fillColor: AppColors.greyText,
            filled: true,
            border: OutlineInputBorder(
              borderRadius: BorderRadius.circular(10.r),
              borderSide: BorderSide.none,
            ),
            enabledBorder: OutlineInputBorder(
              borderRadius: BorderRadius.circular(10.r),
              borderSide: BorderSide.none,
            ),
            focusedBorder: OutlineInputBorder(
              borderRadius: BorderRadius.circular(10.r),
              borderSide: BorderSide.none,
            ),
          ),
        ),
      ],
    );
  }
}

//ignore: must_be_immutable
class CommonMultiLineTextFiled extends StatefulWidget {
  final TextEditingController? controller;
  final Function(String)? onChanged;
  final String? hintText;
  final String? prefixIcon;
  String title;
  bool isTitle;
  final Widget? suffixIcon;
  final bool isMaxLines;
  final int? maxLines;
  final Color? titleColor;
  final TextInputAction? textInputAction;
  bool enabled;
  bool obscureText;
  bool suffixVisibility;

  CommonMultiLineTextFiled({
    super.key,
    this.controller,
    this.suffixIcon,
    this.prefixIcon,
    this.onChanged,
    this.isMaxLines = false,
    this.maxLines,
    this.hintText,
    this.obscureText = false,
    this.suffixVisibility = false,
    this.enabled = true,
    this.textInputAction = TextInputAction.next,
    this.titleColor = AppColors.darkBlueText,
    this.title = "",
    this.isTitle = true,
  });

  @override
  State<CommonMultiLineTextFiled> createState() => _CommonMultiLineTextFiledState();
}

class _CommonMultiLineTextFiledState extends State<CommonMultiLineTextFiled> {
  toggle() {
    setState(() {
      widget.obscureText = !widget.obscureText;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Visibility(
            visible: widget.isTitle,
            child: AppText(
              widget.title,
              textAlign: TextAlign.center,
              color: widget.titleColor ?? AppColors.black,
              fontFamily: FontFamily.montserratSemiBold,
              fontWeight: FontWeight.w600,
              fontSize: 16.sp,
            ),
          ),
          Visibility(visible: widget.isTitle, child: SizedBox(height: 10.h)),
          TextFormField(
            controller: widget.controller,
            onChanged: widget.onChanged,
            obscureText: widget.obscureText,
            textInputAction: widget.textInputAction,
            maxLines: widget.isMaxLines ? widget.maxLines : null,
            enabled: widget.enabled,
            style: TextStyle(
              color: AppColors.darkBlueText,
              fontFamily: FontFamily.montserratSemiBold,
              fontWeight: FontWeight.w600,
              fontSize: 16.sp,
            ),
            decoration: InputDecoration(
              hintText: widget.hintText ?? "",
              prefixIcon: widget.prefixIcon == null
                  ? null
                  : Padding(
                      padding: EdgeInsets.only(left: 15.w, right: 10.w),
                      child: Image.asset(
                        widget.prefixIcon!,
                        height: 24.h,
                        width: 24.w,
                      ),
                    ),
              suffixIcon: widget.suffixVisibility == false
                  ? widget.suffixIcon
                  : Visibility(
                      visible: widget.suffixVisibility,
                      child: GestureDetector(
                        onTap: toggle,
                        child: Container(
                          margin: EdgeInsets.all(14.sp),
                          child: Image.asset(
                            widget.obscureText ? AppImages.eye : AppImages.eyeSlash,
                            height: 24.h,
                            width: 24.w,
                          ),
                        ),
                      ),
                    ),
              hintStyle: TextStyle(
                color: AppColors.darkBlue400,
                fontFamily: FontFamily.montserratMedium,
                fontSize: 16.sp,
                fontWeight: FontWeight.w500,
              ),
              labelStyle: TextStyle(
                color: AppColors.darkBlueText,
                fontFamily: FontFamily.montserratSemiBold,
                fontWeight: FontWeight.w500,
                fontSize: 16.sp,
              ),
              contentPadding: EdgeInsets.symmetric(vertical: 14.h, horizontal: 2.w),
              fillColor: AppColors.transparent,
              filled: true,
              border: OutlineInputBorder(
                borderRadius: BorderRadius.circular(10.r),
                borderSide: BorderSide.none,
              ),
              enabledBorder: OutlineInputBorder(
                borderRadius: BorderRadius.circular(10.r),
                borderSide: BorderSide.none,
              ),
              focusedBorder: OutlineInputBorder(
                borderRadius: BorderRadius.circular(10.r),
                borderSide: BorderSide.none,
              ),
            ),
          ),
        ],
      ),
    );
  }
}
