import 'package:voice_buddies/app/widget/common_container.dart';

import '../utils/all_imports.dart';

class CommonDropDown extends StatelessWidget {
  final ValueChanged<String?>? onChanged;
  final List<String>? itemsList;
  final String? dropdownValue;
  final String? hint;
  final Widget? icon;
  final int? elevation;
  final Color? dropdownColor;
  final Color? textColor;
  final double? textSize;
  final FontWeight? textWeight;
  final double? textHeight;
  final AlignmentGeometry? alignment;
  final bool? autofocus;
  final Color? focusColor;
  final double? iconSize;
  final bool? isExpanded;
  final bool? isDense;
  final Color? iconDisabledColor;
  final Color? iconEnabledColor;
  final Color? titleColor;
  final Widget? underline;
  final double? menuMaxHeight;
  final String? title;
  final FontWeight? titleFontWeight;

  const CommonDropDown({
    Key? key,
    this.onChanged,
    required this.itemsList,
    this.dropdownValue,
    this.icon,
    this.elevation,
    this.dropdownColor,
    this.textColor,
    this.textSize,
    this.textWeight,
    this.textHeight,
    this.alignment,
    this.autofocus,
    this.focusColor,
    this.iconSize,
    this.isExpanded,
    this.isDense,
    this.iconDisabledColor,
    this.iconEnabledColor,
    this.underline,
    this.menuMaxHeight,
    this.title,
    this.titleColor,
    this.titleFontWeight,
    this.hint,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        AppText(
          title ?? "",
          textAlign: TextAlign.center,
          color: titleColor ?? AppColors.darkBlue400,
          fontFamily: FontFamily.montserratSemiBold,
          fontWeight: titleFontWeight ?? FontWeight.w500,
          fontSize: 16.sp,
        ),
        SizedBox(height: 10.h),
        CommonContainer(
          height: 50.h,
          padding: EdgeInsets.symmetric(horizontal: 15.w),
          alignment: Alignment.center,
          isBorderRadius: true,
          borderRadius: 10.r,
          child: DropdownButton(
            value: dropdownValue,
            hint: Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                AppText(
                  hint!,
                  textAlign: TextAlign.start,
                  color: AppColors.darkBlue400,
                  fontSize: 16.sp,
                  fontWeight: FontWeight.w600,
                  height: textHeight,
                ),
              ],
            ),
            icon: icon ?? Image.asset(AppImages.icDown),
            dropdownColor: dropdownColor ?? AppColors.greyBG,
            borderRadius: BorderRadius.circular(10.r),
            elevation: elevation ?? 8,
            style: TextStyle(
              color: textColor ?? AppColors.darkBlue600,
              fontSize: textSize ?? 16.sp,
              fontWeight: textWeight ?? FontWeight.w600,
              height: textHeight,
              fontFamily: FontFamily.montserratRegular,
            ),
            alignment: alignment ?? Alignment.center,
            autofocus: autofocus ?? false,
            focusColor: focusColor,
            iconSize: iconSize ?? 24.h,
            isExpanded: isExpanded ?? true,
            isDense: isDense ?? true,
            iconDisabledColor: iconDisabledColor,
            iconEnabledColor: iconEnabledColor,
            underline: underline ?? Container(),
            menuMaxHeight: menuMaxHeight,
            onChanged: onChanged!,
            items: itemsList!.map((String value) {
              return DropdownMenuItem(
                value: value,
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    AppText(
                      value,
                      fontFamily: FontFamily.montserratRegular,
                      color: itemsList![0] == value ? AppColors.darkBlue400 : AppColors.darkBlueText,
                      fontSize: 16.sp,
                      fontWeight: FontWeight.w600,
                    ),
                  ],
                ),
              );
            }).toList(),
          ),
        ),
      ],
    );
  }
}
