import '../utils/all_imports.dart';

class CommonButton extends StatelessWidget {
  final Function()? onTap;
  final Color? backGroundColor;
  final Color? fontColor;
  final String? buttonTitle;
  final String? fontFamily;
  final IconData? sufixIcon;
  final bool? isSufixIcon;
  final FontWeight? fontWeight;
  final double? fontSize;
  final double? width;
  final double? height;
  const CommonButton({
    this.backGroundColor,
    this.buttonTitle,
    this.onTap,
    this.fontSize,
    this.fontWeight,
    this.fontFamily,
    this.sufixIcon,
    this.fontColor,
    this.width,
    this.height,
    this.isSufixIcon = false,
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        // padding: EdgeInsets.symmetric(vertical: 12.h),
        width: width ?? double.infinity,
        height: height ?? 51.h,
        decoration: BoxDecoration(
            color: backGroundColor ?? AppColors.white,
            borderRadius: BorderRadius.circular(10.r),
            gradient: const LinearGradient(colors: [
              AppColors.greenGradient1,
              AppColors.greenGradient2,
              AppColors.greenGradient3,
            ])),
        alignment: Alignment.center,
        child: Center(
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              AppText(
                buttonTitle ?? "",
                textAlign: TextAlign.center,
                fontSize: fontSize ?? 18.sp,
                maxLines: 1,
                fontWeight: fontWeight ?? FontWeight.w600,
                fontFamily: fontFamily ?? FontFamily.montserratSemiBold,
                color: fontColor ?? AppColors.white,
              ),
              isSufixIcon!
                  ? Padding(
                      padding: EdgeInsets.only(right: 3.w),
                      child: Icon(
                        sufixIcon!,
                        size: 11.w,
                        color: AppColors.white,
                      ),
                    )
                  : Container(),
            ],
          ),
        ),
      ),
    );
  }
}
