import 'dart:ui';

import '../utils/all_imports.dart';

CommonBottomSheet({
  required BuildContext context,
  required Widget child,
}) {
  return showModalBottomSheet(
    isScrollControlled: true,
    backgroundColor: AppColors.transparent,
    context: context,
    builder: (context) => StatefulBuilder(builder: (context, setState) {
      return BackdropFilter(
        // blendMode: BlendMode.softLight,
        filter: ImageFilter.blur(sigmaX: 1.0, sigmaY: 1.0),
        child: Padding(
          padding: EdgeInsets.only(left: 15.w, right: 15.w),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Container(
                // height: 50.h,
                // width: 80.w,
                padding: EdgeInsets.all(4.w),
                decoration: BoxDecoration(color: AppColors.white, borderRadius: BorderRadius.circular(6.w)),
                child: child,
              ),
              SizedBox(height: 5.h)
            ],
          ),
        ),
      );
    }),
  );
}
