import '../utils/all_imports.dart';

class CommonScreen extends StatelessWidget {
  final Widget? body;
  final Widget? child;
  final Widget? bottomBar;
  final Widget? floatingActionButton;
  final bool? isFloatingActionButton;
  final bool? isSafeArea;
  final bool? isBottomBar;
  final bool? isAppBar;
  final bool? isLeading;
  final bool? isCenter;
  final bool isBackButton;
  final String? title;
  final Color? textColor;
  final Color? backGroundColor;
  final Color? appbarBgColor;
  final String? bgImage;
  final List<Widget>? action;
  final Widget? titleWidget;
  final double? prefSize;
  final BoxFit? bgFit;
  final void Function()? onTap;

  const CommonScreen({
    this.body,
    this.isSafeArea = true,
    this.isAppBar = true,
    this.isBottomBar = false,
    this.isFloatingActionButton = false,
    this.bottomBar,
    this.bgFit,
    this.floatingActionButton,
    this.isLeading,
    this.isCenter = true,
    this.title,
    this.textColor,
    this.backGroundColor,
    this.child,
    this.appbarBgColor,
    this.action,
    this.onTap,
    this.bgImage,
    this.isBackButton = true,
    this.titleWidget,
    this.prefSize,
  });

  @override
  Widget build(BuildContext context) {
    Utils.lightStatusBar();
    return Scaffold(
      resizeToAvoidBottomInset: true,
      backgroundColor: backGroundColor ?? AppColors.greyBG,
      extendBody: true,
      appBar: !isAppBar!
          ? null
          : CommonAppBar(
              isCenter: isCenter,
              title: title,
              titleWidget: titleWidget,
              textColor: textColor,
              appbarBgColor: appbarBgColor,
              action: action,
              onTap: onTap,
              isBackButton: isBackButton,
              prefSize: prefSize,
            ),
      bottomNavigationBar: !isBottomBar! ? null : bottomBar,
      floatingActionButton: !isFloatingActionButton! ? null : floatingActionButton,
      floatingActionButtonLocation: FloatingActionButtonLocation.centerDocked,
      body: GestureDetector(
        onTap: () {
          utils.hideKeyboard(context);
        },
        child: SafeArea(
          top: isSafeArea!,
          bottom: false,
          child: body ??
              Container(
                height: Get.height,
                width: Get.width,
                decoration: BoxDecoration(
                  image: DecorationImage(image: AssetImage(bgImage ?? AppImages.screenBgBox), fit: bgFit ?? BoxFit.cover),
                ),
                child: child,
              ),
        ),
      ),
    );
  }
}
