import 'dart:core';

class AppStrings {
  static const String flutterSdkVersion = "3.13.8";

  static const String appName = "Voice Buddies";

  /// <<<--------- ERROR MESSAGE ------------------>>>
  static const String errorMessageVoiceBuddiesUniqueId = "Please enter Voice Buddies ID";
  static const String errorMessageFirstName = "Please enter first name";
  static const String errorMessageEmail = "Please enter email";
  static const String errorMessageEmailToSentCode = "Please enter your email address. We will send a confirmation code there";
  static const String errorMessageValidEmail = "Please enter valid email address";
  static const String errorMessagePassword = "Please enter password";
  static const String errorMessageNewPassword = "Please enter new password";
  static const String errorMessageCurrentPassword = "Please enter current password";
  static const String errorMessageConfirmPassword = "Please enter your confirm password";
  static const String errorMessageValidPhone = "Please enter valid phone number";

  // static const String errorMessageConfirmPassword = "Please enter confirm password";
  // static const String errorMessageNotMatchPass = "Password and confirm password does not match";
  static const String errorMessageNotMatchPass = "Passwords don’t match.";
  static const String errorMessageOtp = "Please enter otp";
  static const String errorMessageValidOTP = "Please enter valid OTP";

  static const String errorMessageValidPassword = "Password must be more than 8 characters long including lower case, upper case, number and a special character";
  static const String errorMessageNewValidPassword = "New Password must be more than 8 characters long including lower case, upper case, number and a special character";
  static const String errorMessagePrivacyAndTerms = "Please agreed to our Terms & Conditions";

  // static const String errorMessagePrivacyAndTerms = "Please agreed to our Privacy Policy and Terms & Conditions";
  static const String errorMessageMessage = "Please enter message";
  static const String errorMessageSubject = "Please enter subject";
  static const String errorMessageName = "Please enter name";

  static const String passwordNewErrorMessage = "Please enter new password";
  static const String passwordErrorOldMessage = "Please enter old password";
  static const String passValidErrorMessage = "Your password needs to be between 6 to 12 characters long with no spaces";

  static const String noDataFound = "No data found";

  /// -------------------- Login ----------------- ////
  static const String welcomeBack = "Welcome Back";
  static const String email = "Email";
  static const String emailPhoneNumber = "Email / Phone";
  static const String phoneNumber = "Phone number";
  static const String password = "Password";
  static const String signIn = "Sign In";
  static const String signup = "Sign Up";
  static const String enterEmail = "Enter Email";
  static const String enterEmailPhoneNumber = "Enter Email/Phone number";
  static const String enterPassword = "Enter Password";
  static const String enterConfirmPassword = "Enter Confirm Password";
  static const String forgetPassword = "Forgot Password?";
  static const String doesNotHaveAnAccount = "Don’t have an account?";
  static const String doesNotReceiveEmail = "Didn't receive the email?";

  /// -------------------- ForgotPassword ----------------- ////
  static const String send = "Send";
  static const String noWorries = "No worries, we'll send\nyou reset instructions.";

  /// -------------------- Otp ----------------- ////
  static const String verification = "Verification";
  static const String continues = "Continue";
  static const String weSentACode = "We sent a code";
  static const String enterCode = "enter code below ";
  static const String resend = "Resend";
  // static const String pleaseEnterOtp = "Please enter OTP!";
  static const String pleaseEnterOtp = "Please enter the password that was emailed to you";
  static const String exitAlertMessage = "Tap the back button once more to \nexit the app";

  /// -------------------- NewPassword ----------------- ////
  static const String setNewPassword = "Set New Password";
  static const String mustBeEight = "Must be at least 8 characters.";
  static const String newPassword = "New Password";
  static const String enterNewPassword = "Enter New Password";
  static const String confirmPassword = "Confirm Password";
  static const String resetPassword = "Reset Password";

  /// -------------------- Done ----------------- ////
  static const String allDone = "All Done";
  static const String congratulations = "Congratulations!";
  static const String ok = "Ok";
  static const String yourAccountSuccessFully = "Your account has been\nsuccessfully created.";
  static const String yourAccountSuccessFully2 = "Your signup process is complete. Your profile is now under review by the admin. After approval, you will receive a confirmation email and be able to log in to the app.";
  static const String yourPasswordHasReset = "Your password has been reset.";
  static const String profileUpdated = "Profile Updated!";
  static const String youHaveProfileUpdated = "You have successfully updated\nyour profile information.";
  static const String passwordChanged = "Password Changed!";
  static const String passwordChangedSuccessfully = "Your password has been\nchanged successfully.";

  /// -------------------- SignUp ----------------- ////
  static const String createYourProfile = "Create Your Profile";
  static const String voiceBuddiesID = "Voice Buddies ID";
  static const String firstName = "First Name";
  static const String termsConditions = "Terms & Conditions";
  static const String privacyPolicy = "Privacy Policy.";
  static const String iHaveReadThe = "I have read the";
  static const String andThe = " and the ";
  static const String enterVoiceBuddiesId = "Enter Voice Buddy Id";
  static const String enterFirstName = "Enter First Name";

  /// -------------------- UserDetails ----------------- ////
  static const String gender = "Gender";
  static const String age = "Age";
  static const String currentlyIAm = "Currently I am";
  static const String occupation = "Occupation";
  static const String selectOccupation = "Select occupation";
  static const String whereILive = "Where I live";
  static const String location = "Location";
  static const String spokenLanguages = "I Speak";
  static const String languages = "Languages";
  static const String createVoiceRecording = "Create Voice Recording";
  static const String selectUpToThreeLanguage = "Select up to three languages you are fluent in";

  static const String pleaseMakeASelection = "Please make a selection";

  /*static const String pleaseSelectGender = "Please select gender!";
  static const String pleaseSelectAge = "Please select age!";
  static const String pleaseSelectCurrentlyIAm = "Please select currently i am!";
  static const String pleaseSelectWhereILive = "Please select where i live!";
  static const String pleaseSelectSpokenLan = "Please select spoken language!";*/
  static const String pleaseRecordSomethingAboutYourself = "Please record something about yourself";
  static const String pleaseStopRecorder = "Please stop recorder";
  static const String recordingSaved = "Recording saved";

  static const String selectGender = "Select gender";
  static const String selectAge = "Select age";
  static const String selectCurrentlyIAm = "Select currently i am";
  // static const String selectContinent = "Select where i live";
  static const String selectContinent = "Select continent";
  static const String selectSpokenLan = "Select spoken languages";

  static const String male = "Male";
  static const String female = "Female";
  static const String other = "Other";
  static const String decline = "Decline";

  static const String lessThan = "Less than 20";
  static const String twentyToTwentyNine = "20-29";
  static const String thirtyToThirtyNine = "30-39";
  static const String fourTyToFourTyNine = "40-49";
  static const String fiftyPlus = "50+";

  static const String atSchool = "At School";
  static const String atCollege = "At College";
  static const String working = "Working";
  static const String inBetweenJobs = "In Between Jobs";

  static const String northAmerica = "North America";
  static const String southAmerica = "South America";
  static const String europe = "Europe";
  static const String africa = "Africa";
  static const String asia = "Asia";
  static const String australia = "Australia";

  static const String english = "English";
  static const String spanish = "Spanish";
  static const String french = "French";
  static const String german = "German";
  static const String arabic = "Arabic";
  static const String russian = "Russian";
  static const String portuguese = "Portuguese";
  static const String mandarin = "Mandarin";
  static const String cantonese = "Cantonese";
  static const String korean = "Korean";
  static const String hindi = "Hindi";
  static const String bengali = "Bengali";
  static const String urdu = "Urdu";
  static const String tamil = "Tamil";
  static const String telugu = "Telugu";

  static const String pleaseTapThisGreenMikeIcon =
      // "Press this button to start recording something about yourself. It will appear in your profile page for all to hear. If you are not happy with your recording simply press this button again to re-record.";
      "Press this button to start or stop recording.";
  static const String pleaseTapOrangePlayButton = "Press this button if you want to listen to what you recorded.";
  static const String pleaseTapTickButton = 'If all is going well, press this button to save your recording.';
  static const String pleaseTapToCompleteSignUp = 'Once all is done press this button to complete the signup process';
  static const String tapGreenMike = "Press this button to record your voice message.";
  static const String tapGreenPause = "Press this button when you have finished your recording.";
  static const String tapGreenPlay = "After recording, if you want to listen, please tap the green Play button.";
  static const String tapGreenSend = "Press this button to send your voice message to your friend.";

  static const String gotIt = "Got it";
  static const String howItWorks = "How it works";
  static const String tipsForYourVoiceRecording = "Tips for your Voice \nRecording";
  static const String suggestionForYourVoiceRecording = "Suggestions For Your\nVoice Recording";
  static const String tellPeopleAboutYourSelf = "Tell people about yourself";
  static const String tips = "Tips";

  /// -------------------- UserDetails ----------------- ////
  static const String getStarted = "Get Started";

  /// -------------------- BottomBar ---------------»-- ////
  static const String inbox = "Inbox";
  static const String search = "Search";
  static const String settings = "Settings";
  static const String vb = "VB";

  /// -------------------- Message ----------------- ////
  static const String voiceRecordingFrom = "Voice Recording From";
  static const String recordAndSendAVoiceRecording = "Record And Send A Voice Recording";
  static const String accountHasBeenDeleted = "Account has been deleted";
  static const String newMessages = "New Messages";
  static const String delete = "Delete";
  static const String download = "Download";
  static const String flag = "Flag";
  static const String block = "Block";
  static const String oldMessages = "Old Messages";
  static const String help = "Help";
  static const String downloadedSuccessfully = "Downloaded Successfully!";
  static const String downloadFail = "Download failed!";
  static const String recordingStarted = "Voice recording started";
  static const String recordingStop = "Voice recorded successfully";
  static const String pleaseStopRecordingToPlay = "Please stop recording to play!";
  static const String messageDeleted = "Message deleted";
  static const String recordingNotFound = "Recording not found please record to play";
  static const String yourMessageHasBeenSent = "Your message has been sent";
  static const String toSendVoiceMessage = "To send voice message";

  /// -------------------- Flag ----------------- ////
  static const String attachment = "Attachment";
  static const String writeAMessage = "Write a Message";
  static const String pleaseEnterMessage = "Please enter message!";
  static const String done = "Done";

  /// -------------------- Search ----------------- ////
  static const String searchNameOrID = "Search Name or ID";
  static const String enterNameOrID = "Enter Name or ID";
  static const String searchResult = "Search Result";
  static const String any = "Any";
  static const String pleaseSelectAtListOneField = "Please select at list one field";

  /// -------------------- UserProfile ----------------- ////
  static const String aboutMe = "About Me";
  static const String myDetails = "My Details";
  static const String changePassword = "Change Password";
  static const String save = "Save";
  static const String pleaseRecordMessageToSend = "Please record message to send";

  /// -------------------- Settings ----------------- ////
  static const String editProfile = "Edit Profile";
  static const String whoIBlocked = "Who I Blocked";
  static const String deleteAccount = "Delete Account";
  static const String notification = "Notification";
  static const String logout = "Logout";
  static const String recording = "Recording";

  /// -------------------- ChangePassword ----------------- ////
  static const String currentPassword = "Current Password";
  static const String enterCurrentPassword = "Enter Current Password";
  static const String confirmNewPassword = "Confirm New Password";
  static const String enterConfirmNewPassword = "Enter Confirm New Password";
  static const String update = "Update";

  /// -------------------- DeleteAccount ----------------- ////
  static const String reason = "Reason";
  static const String imUsingDifferentAccount = "I’m using different account";
  static const String theAppIsNtWorkingProperly = "The app isn’t working properly";
  static const String imWorriedAboutMyPrivacy = "I’m worried about my privacy";
  static const String noOneReplies = "No one replies";
  static const String message = "Message";
  static const String deleteMyAccount = "Delete My Account";
  static const String imLeavingDoNotPayBecause = "I’m leaving DoNotPay because...";
  static const String pleaseEnterDeleteReason = "Please enter or select account delete reason!";
  static const String pleaseEnterOtherReason = "Please enter other reason";

  /// -------------------- DeleteLogout ----------------- ////
  static const String areYouLeaving = "Are You Leaving?";
  static const String areYouSureYouWantToDeleteYourAccount = "Are you sure you want to\ndelete your account?";
  static const String areYouSureWantToLogoutFromVoiceBuddies = "Are you sure you want to \nlogout from Voice Buddies?";
  static const String yes = "Yes";
  static const String no = "No";

  /// -------------------- VB ----------------- ////
  static const String aboutUs = "About Us";
  static const String ourPlans = "Our Plans";
  static const String contactUs = "Contact Us";
  static const String privacyPolicyS = "Privacy Policy";

  /// -------------------- OurPlans ----------------- ////
  static const String getMoreFriends = "Get More Friends";
  static const String toGetMoreFriends = "To get more friends you can delete an existing friend and replace that person with a new friend. This is free";
  static const String or = "OR";

  /// -------------------- ContactUs ----------------- ////
  static const String name = "Name";
  static const String subject = "Subject";
  static const String submit = "Submit";

  static const String enterName = "Enter Name";
  static const String enterSubject = "Enter Subject";
  static const String enterMessage = "Enter Message";
  static const String requestSent = "Request Sent";
  static const String youHaveSuccessfullySentYourContactUsRequest = "You have successfully sent\nyour contact us request.";

  static const String tipsFirst = "Mention your first name, what country and state you live in and what you do";
  static const String tipsSecond = "How would you (or others) describe yourself?";
  static const String tipsThird = "What type of music do you like the most?";
  static const String tipsFour = "Do you have any hobbies or do you do any regular activities like sports, cheerleading, clubs, charity work etc";
  static const String tipsFive = "Tell us something different about yourself or something funny that happened to you";
  static const String pleaseEnterMessage2 = "Please enter message";
}
