import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../controllers/who_i_blocked_controller.dart';

class WhoIBlockedView extends GetView<WhoIBlockedController> {
  const WhoIBlockedView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<WhoIBlockedController>(
      init: WhoIBlockedController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.whoIBlocked,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.only(left: 20.w, right: 20.w),
            child: controller.blockList.isEmpty
                ? Center(child: AppText(AppStrings.noDataFound, color: AppColors.black, fontSize: 18.sp, fontWeight: FontWeight.w600))
                : ListView.builder(
                    shrinkWrap: true,
                    padding: EdgeInsets.only(bottom: 25.h),
                    physics: const BouncingScrollPhysics(),
                    itemCount: controller.blockList.length,
                    itemBuilder: (context, index) {
                      return GestureDetector(
                        onTap: () {},
                        child: CommonContainer(
                          margin: EdgeInsets.only(top: 15.h),
                          borderRadius: 10.r,
                          isBorderRadius: true,
                          alignment: Alignment.topLeft,
                          padding: EdgeInsets.symmetric(horizontal: 15.w),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  AppText(
                                    controller.blockList[index].fname.toString(),
                                    color: AppColors.darkBlueText,
                                    fontSize: 16.sp,
                                    fontWeight: FontWeight.w600,
                                  ),
                                  SizedBox(height: 8.h),
                                  AppText(
                                    controller.blockList[index].uniqueId.toString(),
                                    color: AppColors.darkBlue400,
                                    fontSize: 14.sp,
                                    fontWeight: FontWeight.w500,
                                  ),
                                ],
                              ),
                              GestureDetector(
                                onTap: () {
                                  controller.unBlockUserApi(index: index, blockedUserId: controller.blockList[index].userId);
                                },
                                child: Image.asset(
                                  AppImages.icUnlock,
                                  height: 24.h,
                                  width: 24.w,
                                ),
                              )
                            ],
                          ),
                        ),
                      );
                    },
                  ),
          ),
        );
      },
    );
  }
}
