import 'package:voice_buddies/app/models/block_list_model.dart';
import 'package:voice_buddies/app/models/login_model.dart';
import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../utils/all_imports.dart';

class WhoIBlockedController extends BaseController {
  List<BlockList> blockList = [];

  bool isData = false;
  @override
  void onInit() {
    getUserData();
    getBlockUsersApi();
    super.onInit();
  }

  ///  getBlockUsersApi
  getBlockUsersApi() async {
    FormData formData = FormData.fromMap({
      "user_id": loginData?.userId,
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.getBlockUsers,
      params: formData,
      token: loginData?.token,
    );
    BlockListModel model = BlockListModel.fromJson(data);
    if (model.responseCode == 1) {
      isData = true;
      blockList = model.data!;
      update();
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }

  ///  unBlockUserApi
  unBlockUserApi({index, blockedUserId}) async {
    FormData formData = FormData.fromMap({
      "user_id": loginData?.userId,
      "user_to": blockedUserId,
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.blockUnBlockUser,
      params: formData,
      token: loginData?.token,
    );
    LoginDataModel model = LoginDataModel.fromJson(data);
    if (model.responseCode == 1) {
      blockList.removeAt(index);
      utils.showToast(message: model.responseMsg!);
      update();
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
