import 'package:country_picker/country_picker.dart';
import 'package:flutter/foundation.dart';
import 'package:get/get_rx/src/rx_types/rx_types.dart';
import 'package:voice_buddies/app/api_repository/api_class.dart';
import 'package:voice_buddies/app/models/login_model.dart';

import '../../../utils/all_imports.dart';

class SignupController extends GetxController {
  TextEditingController id = TextEditingController();
  TextEditingController firstName = TextEditingController(text: kDebugMode ? 'Bhumit sabhaya' : '');
  TextEditingController email = TextEditingController(text: kDebugMode ? 'bhumit.kmphitech@gmail.com' : '');
  TextEditingController phone = TextEditingController(text: kDebugMode ? '9054519181' : '');
  TextEditingController password = TextEditingController(text: kDebugMode ? 'Bhumit@123' : '');
  TextEditingController confirmPassword = TextEditingController(text: kDebugMode ? 'Bhumit@123' : '');
  RxBool isPrivacyAccept = kDebugMode.obs;

  Rx<Country>? selectedCountry;

  @override
  void onInit() {
    selectedCountry = Country(
      countryCode: "US",
      phoneCode: "1",
      displayName: "United States (US) [+1]",
      e164Key: '54-AR-0',
      e164Sc: 0,
      geographic: true,
      level: 1,
      example: '2012345678',
      name: 'United States',
      displayNameNoCountryCode: 'United States (US)',
    ).obs;
    getVoiceBuddiesID();
    super.onInit();
  }

  getVoiceBuddiesID() async {
    FormData formData = FormData.fromMap({});
    final data = await APIFunction().apiCall(
      apiName: Constants.getVoiceBuddiesID,
      params: formData,
    );
    LoginDataModel model = LoginDataModel.fromJson(data);
    if (model.responseCode == 1) {
      id.text = model.data!.uniqueId!;
      update();
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }

  /// validation
  bool isValidation() {
    if (utils.isValidationEmpty(id.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageVoiceBuddiesUniqueId);
      return false;
    } else if (utils.isValidationEmpty(firstName.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageFirstName);
      return false;
    } else if (utils.isValidationEmpty(email.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageEmailToSentCode);
      return false;
    } else if (!utils.emailValidator(email.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageValidEmail);
      return false;
    } else if (utils.isValidationEmpty(phone.text.trim())) {
      utils.showToast(message: AppStrings.errorMessageName + AppStrings.phoneNumber.toLowerCase());

      return false;
    } else if (phone.text.trim().length != selectedCountry?.value.example.length) {
      utils.showToast(message: AppStrings.errorMessageValidPhone);
      return false;
    } else if (utils.isValidationEmpty(password.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessagePassword);
      return false;
    } else if (!utils.passwordValidator(password.text)) {
      utils.showSnackBar(message: AppStrings.errorMessageValidPassword);
      return false;
    } else if (utils.isValidationEmpty(confirmPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageConfirmPassword);
      return false;
    } else if (password.text.trim() != confirmPassword.text.trim()) {
      utils.showSnackBar(message: AppStrings.errorMessageNotMatchPass);
      return false;
    } else if (!isPrivacyAccept.value) {
      utils.showSnackBar(message: AppStrings.errorMessagePrivacyAndTerms);
      return false;
    }
    return true;
  }

  checkEmailApi() async {
    FormData formData = FormData.fromMap({
      "email": email.text,
      HttpUtil.ccode: selectedCountry?.value.phoneCode,
      HttpUtil.phone: phone.text.trim(),
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.checkEmail,
      params: formData,
    );
    LoginDataModel model = LoginDataModel.fromJson(data);
    if (model.responseCode == 1) {
      Get.toNamed(
        Routes.USER_DETAILS,
        arguments: [
          "",
          1,
          true,
          id.text,
          firstName.text.trim(),
          email.text.trim(),
          password.text.trim(),
          selectedCountry?.value.phoneCode,
          phone.text.trim(),
        ],
      );
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
