import 'package:voice_buddies/app/helper/iphone_has_notch.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../controllers/search_result_controller.dart';

class SearchResultView extends GetView<SearchResultController> {
  const SearchResultView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SearchResultController>(
      init: SearchResultController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.searchResult,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(
              horizontal: 20.w,
            ),
            child: (controller.searchResult.isEmpty)
                ? Center(
                    child: AppText(
                      AppStrings.noDataFound,
                      color: AppColors.black,
                      fontSize: 18.sp,
                      fontWeight: FontWeight.w600,
                    ),
                  )
                : ListView.separated(
                    shrinkWrap: true,
                    controller: controller.scrollController,
                    padding: EdgeInsets.only(bottom: (IphoneHasNotch.hasNotch) ? 30.h : 20.h),
                    physics: const BouncingScrollPhysics(),
                    itemCount: controller.searchResult.length,
                    separatorBuilder: (context, index) {
                      return SizedBox(height: 15.h);
                    },
                    itemBuilder: (context, index) {
                      return GestureDetector(
                        onTap: () {
                          Get.toNamed(Routes.USER_PROFILE, arguments: controller.searchResult[index]);
                        },
                        child: CommonContainer(
                          borderRadius: 10.r,
                          isBorderRadius: true,
                          alignment: Alignment.topLeft,
                          padding: EdgeInsets.all(15.h),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  AppText(
                                    controller.searchResult[index].fname ?? "",
                                    color: AppColors.darkBlueText,
                                    fontSize: 16.sp,
                                    fontWeight: FontWeight.w600,
                                  ),
                                  SizedBox(height: 8.h),
                                  AppText(
                                    controller.searchResult[index].uniqueId ?? "",
                                    color: AppColors.darkBlue400,
                                    fontSize: 14.sp,
                                    fontWeight: FontWeight.w500,
                                  ),
                                ],
                              ),
                              Image.asset(
                                AppImages.icYellowNext,
                                height: 40.h,
                                width: 40.w,
                              )
                            ],
                          ),
                        ),
                      );
                    }),
          ),
        );
      },
    );
  }
}

/// apicall done
// import 'package:voice_buddies/app/widget/common_container.dart';
//
// import '../../../utils/all_imports.dart';
// import '../controllers/search_result_controller.dart';
//
// class SearchResultView extends GetView<SearchResultController> {
//   const SearchResultView({Key? key}) : super(key: key);
//   @override
//   Widget build(BuildContext context) {
//     return GetBuilder<SearchResultController>(
//       init: SearchResultController(),
//       assignId: true,
//       builder: (controller) {
//         return CommonScreen(
//           isAppBar: true,
//           isSafeArea: false,
//           isLeading: true,
//           isBackButton: true,
//
//           title: AppStrings.searchResult,
//           textColor: AppColors.blackAppbar,
//           body: Padding(
//             padding: EdgeInsets.symmetric(
//               horizontal: 20.w,
//             ),
//             child: controller.searchResult.isEmpty
//                 ? Center(
//                     child: Column(
//                       mainAxisAlignment: MainAxisAlignment.center,
//                       children: [
//                         AppText(
//                           AppStrings.noDataFound,
//                           color: AppColors.darkBlue700,
//                           fontFamily: FontFamily.montserratRegular,
//                           fontWeight: FontWeight.w500,
//                           fontSize: 20.sp,
//                         ),
//                       ],
//                     ),
//                   )
//                 : ListView.builder(
//                     shrinkWrap: true,
//                     padding: EdgeInsets.only(bottom: 25.h),
//                     physics: const BouncingScrollPhysics(),
//                     itemCount: controller.searchResult.length,
//                     itemBuilder: (context, index) {
//                       return GestureDetector(
//                         onTap: () {
//                           Get.toNamed(Routes.USER_PROFILE, arguments: controller.searchResult[index]);
//                         },
//                         child: CommonContainer(
//                           margin: EdgeInsets.only(top: 15.h),
//                           height: 77.h,
//                           borderRadius: 10.r,
//                           isBorderRadius: true,
//                           alignment: Alignment.topLeft,
//                           padding: EdgeInsets.symmetric(horizontal: 15.w),
//                           child: Row(
//                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                             children: [
//                               Column(
//                                 crossAxisAlignment: CrossAxisAlignment.start,
//                                 mainAxisAlignment: MainAxisAlignment.center,
//                                 children: [
//                                   AppText(
//                                     controller.searchResult[index].fname.toString(),
//                                     color: AppColors.darkBlueText,
//                                     fontSize: 16.sp,
//                                     fontWeight: FontWeight.w600,
//                                   ),
//                                   SizedBox(height: 8.h),
//                                   AppText(
//                                     controller.searchResult[index].uniqueId.toString(),
//                                     color: AppColors.darkBlue400,
//                                     fontSize: 14.sp,
//                                     fontWeight: FontWeight.w500,
//                                   ),
//                                 ],
//                               ),
//                               Image.asset(
//                                 AppImages.icYellowNext,
//                                 height: 40.h,
//                                 width: 40.w,
//                               )
//                             ],
//                           ),
//                         ),
//                       );
//                     }),
//           ),
//         );
//       },
//     );
//   }
// }
