import 'package:voice_buddies/app/api_repository/api_class.dart';
import 'package:webview_flutter/webview_flutter.dart';

import '../../../utils/all_imports.dart';

class PrivacyPolicyController extends GetxController {
  WebViewController? webController;
  String title = "";
  String url = "";
  bool isHide = true;
  @override
  Future<void> onInit() async {
    await getData();
    showLoader(true);
    webController = WebViewController()
      ..setNavigationDelegate(
        NavigationDelegate(
          onPageFinished: (String url) {
            debugPrint('Page finished loading: $url');
            showLoader(false);
            update();
          },
        ),
      );
    webController!.loadRequest(Uri.parse(url));
    super.onInit();
  }

  void showLoader(bool isLoading) {
    isHide = isLoading;

    if (isLoading) {
      Loading.show();
    } else {
      Loading.dismiss();
    }
  }

  @override
  void onClose() {
    showLoader(false);
    super.onClose();
  }

  getData() {
    if (Get.arguments != null) {
      if (Get.arguments[HttpUtil.tital] != null) {
        title = Get.arguments[HttpUtil.tital];
      }
      if (Get.arguments[HttpUtil.url] != null) {
        url = Get.arguments[HttpUtil.url];
      }
    }
  }
}
