import '../../../utils/all_imports.dart';
import '../controllers/plans_controller.dart';

class PlansView extends GetView<PlansController> {
  const PlansView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<PlansController>(
      init: PlansController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.ourPlans,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 50.h),
                GradientAppText(
                  AppStrings.getMoreFriends,
                  isGreenGradient: false,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 24.sp,
                ),
                Padding(
                  padding: EdgeInsets.symmetric(horizontal: 37.w),
                  child: AppText(
                    AppStrings.toGetMoreFriends,
                    color: AppColors.darkBlue700,
                    textAlign: TextAlign.center,
                    fontWeight: FontWeight.w400,
                    fontSize: 18.sp,
                  ),
                ),
                SizedBox(height: 30.h),
                AppText(
                  AppStrings.or,
                  color: AppColors.darkBlue600,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.w500,
                  fontSize: 16.sp,
                ),
                SizedBox(height: 30.h),
                Image.asset(
                  AppImages.icFreePlan,
                  height: 139.h,
                  width: double.infinity,
                  fit: BoxFit.fill,
                ),
                SizedBox(height: 30.h),
                Image.asset(
                  AppImages.icPaidPlan,
                  height: 170.h,
                  width: double.infinity,
                  fit: BoxFit.fill,
                )
              ],
            ),
          ),
        );
      },
    );
  }
}
