import 'package:otp_text_field/otp_field.dart';
import 'package:otp_text_field/otp_field_style.dart';
import 'package:otp_text_field/style.dart';
import 'package:voice_buddies/app/helper/iphone_has_notch.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_button.dart';
import '../controllers/otp_controller.dart';

class OtpView extends GetView<OtpController> {
  const OtpView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<OtpController>(
      init: OtpController(),
      assignId: true,
      builder: (controller) {
        return GestureDetector(
          onTap: () {
            utils.hideKeyboard(context);
          },
          child: CommonScreen(
            isAppBar: true,
            isSafeArea: false,
            isLeading: true,
            isBackButton: true,
            isBottomBar: true,
            bottomBar: Padding(
              padding: EdgeInsets.only(bottom: (IphoneHasNotch.hasNotch) ? 25.h : 20.h),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  AppText(
                    AppStrings.doesNotReceiveEmail,
                    color: AppColors.darkBlue400,
                    fontWeight: FontWeight.w500,
                    fontSize: 16.sp,
                  ),
                  const Text(" "),
                  GestureDetector(
                    onTap: () {
                      utils.hideKeyboard(context);
                      controller.resendOTP();
                    },
                    child: GradientAppText(
                      AppStrings.resend,
                      fontWeight: FontWeight.w600,
                      fontSize: 16.sp,
                    ),
                  )
                ],
              ),
            ),
            body: Padding(
              padding: EdgeInsets.symmetric(horizontal: 20.w),
              child: ListView(
                shrinkWrap: true,
                padding: EdgeInsets.only(top: 25.h),
                physics: const BouncingScrollPhysics(),
                children: [
                  // SizedBox(height: 40.h),
                  Image.asset(
                    AppImages.icMailImg,
                    width: 240.w,
                    height: 182.w,
                  ),
                  SizedBox(height: 60.h),
                  GradientAppText(
                    AppStrings.verification,
                    textAlign: TextAlign.center,
                    fontWeight: FontWeight.bold,
                    fontSize: 26.sp,
                  ),
                  SizedBox(height: 30.h),
                  AppText(
                    "${AppStrings.weSentACode} to ${(controller.isSignUp.value) ? controller.phone.value : controller.email.text} ${AppStrings.enterCode}",
                    color: AppColors.darkBlue700,
                    textAlign: TextAlign.center,
                    fontWeight: FontWeight.w500,
                    fontSize: 18.sp,
                  ).paddingSymmetric(horizontal: 20.w),
                  SizedBox(height: 30.h),
                  OTPTextField(
                    length: 4,
                    width: MediaQuery.of(context).size.width,
                    fieldWidth: 60,
                    style: TextStyle(color: AppColors.darkBlueText, fontFamily: FontFamily.montserratSemiBold, fontSize: 16.sp, fontWeight: FontWeight.w600),
                    textFieldAlignment: MainAxisAlignment.spaceAround,
                    fieldStyle: FieldStyle.box,
                    otpFieldStyle: OtpFieldStyle(backgroundColor: AppColors.greyText, borderColor: Colors.transparent, disabledBorderColor: Colors.transparent, enabledBorderColor: Colors.transparent, focusBorderColor: Colors.transparent, errorBorderColor: Colors.transparent),
                    onChanged: (value) {
                      controller.pinController.value = value;
                    },
                    onCompleted: (pin) {
                      printAction("Completed: $pin");
                    },
                  ),
                  SizedBox(
                    height: 30.h,
                  ),
                  CommonButton(
                    buttonTitle: AppStrings.continues,
                    onTap: () {
                      if (controller.isOTPValidation()) {
                        if (controller.isSignUp.value) {
                          controller.signUpApi();
                        } else {
                          controller.verifyOtpApi();
                        }
                      }
                    },
                  ),
                  SizedBox(height: 30.h),
                ],
              ),
            ),
          ),
        );
      },
    );
  }
}
