// import 'package:pull_to_refresh/pull_to_refresh.dart';
// import 'package:voice_buddies/app/widget/common_container.dart';
//
// import '../../../utils/all_imports.dart';
// import '../controllers/home_controller.dart';
//
// class HomeView extends GetView<HomeController> {
//   const HomeView({Key? key}) : super(key: key);
//
//   @override
//   Widget build(BuildContext context) {
//     return GetBuilder<HomeController>(
//       init: HomeController(),
//       builder: (controller) {
//         return CommonScreen(
//           isAppBar: true,
//           isSafeArea: false,
//           isLeading: false,
//           isBackButton: false,
//           title: AppStrings.inbox,
//           textColor: AppColors.blackAppbar,
//           body: Padding(
//             padding: EdgeInsets.symmetric(horizontal: 20.w),
//             child: Theme(
//               data: ThemeData(primaryColor: AppColors.greenGradient3),
//               child: SmartRefresher(
//                 controller: controller.refreshController,
//                 onRefresh: () async {
//                   try {
//                     await controller.getMessageList();
//                     controller.refreshController.refreshCompleted();
//                   } catch (e) {
//                     controller.refreshController.refreshCompleted();
//                   }
//                 },
//                 child: ListView(
//                   shrinkWrap: true,
//                   padding: EdgeInsets.zero,
//                   physics: const BouncingScrollPhysics(),
//                   children: [
//                     // client na requirement pramane atyare hide krelu che.
//                     /*Inbox Screen: Please confirm that the red box with white text seen at the top will normally not be present.
//                     It will only show up when I from Admin send a message to everyone or to this individual person.*/
//
//                     !controller.isWarningClose.value ? Container() : SizedBox(height: 10.h),
//                     !controller.isWarningClose.value
//                         ? Container()
//                         : GestureDetector(
//                             onTap: () {
//                               printAction('--------<<<<----->>>>>asasd');
//                             },
//                             child: CommonContainer(
//                               padding: EdgeInsets.symmetric(vertical: 14.h),
//                               isHeight: false,
//                               borderRadius: 10.r,
//                               isBorderRadius: true,
//                               bgImage: const DecorationImage(
//                                   image: AssetImage(
//                                     AppImages.icRedCard,
//                                   ),
//                                   fit: BoxFit.fill),
//                               alignment: Alignment.topRight,
//                               child: Row(
//                                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                                 crossAxisAlignment: CrossAxisAlignment.start,
//                                 children: [
//                                   Container(width: 40.w),
//                                   Expanded(
//                                     child: AppText(
//                                       "*Lorem Ipsum is simply dummy text of the printing and typesetting industry.*",
//                                       color: AppColors.greyBG,
//                                       fontSize: 16.sp,
//                                       textAlign: TextAlign.center,
//                                       fontWeight: FontWeight.w400,
//                                     ),
//                                   ),
//                                   GestureDetector(
//                                     onTap: () {
//                                       controller.isWarningClose.value = true;
//                                       controller.update();
//                                     },
//                                     child: Padding(
//                                       padding: EdgeInsets.only(right: 10.w, left: 20.w),
//                                       child: Icon(Icons.close, color: AppColors.greyBG, size: 24.w),
//                                     ),
//                                   )
//                                 ],
//                               ),
//                             ),
//                           ),
//                     ListView.builder(
//                       shrinkWrap: true,
//                       padding: EdgeInsets.only(bottom: 10.h),
//                       physics: const NeverScrollableScrollPhysics(),
//                       itemCount: controller.msgList.length,
//                       itemBuilder: (context, index) {
//                         return GestureDetector(
//                           onTap: () {
//                             Get.toNamed(Routes.MESSAGE, arguments: controller.msgList[index].name);
//                           },
//                           child: CommonContainer(
//                             margin: EdgeInsets.only(top: 15.h),
//                             height: 77.h,
//                             borderRadius: 10.r,
//                             gradient: controller.msgList[index].isSelected == false
//                                 ? null
//                                 : const LinearGradient(
//                                     colors: [
//                                       AppColors.greenGradient1,
//                                       AppColors.greenGradient2,
//                                       AppColors.greenGradient3,
//                                     ],
//                                   ),
//                             isBorderRadius: true,
//                             alignment: Alignment.topLeft,
//                             padding: EdgeInsets.only(left: 15.w),
//                             child: Column(
//                               crossAxisAlignment: CrossAxisAlignment.start,
//                               mainAxisAlignment: MainAxisAlignment.center,
//                               children: [
//                                 AppText(
//                                   controller.msgList[index].name,
//                                   color: controller.msgList[index].isSelected ? AppColors.lightGreen : AppColors.darkBlueText,
//                                   fontSize: 16.sp,
//                                   fontWeight: FontWeight.w600,
//                                 ),
//                                 SizedBox(height: 8.h),
//                                 AppText(
//                                   controller.msgList[index].details,
//                                   color: controller.msgList[index].isSelected ? AppColors.greyBG : AppColors.darkBlue400,
//                                   fontSize: 14.sp,
//                                   fontWeight: FontWeight.w500,
//                                 ),
//                               ],
//                             ),
//                           ),
//                         );
//                       },
//                     ),
//                   ],
//                 ),
//               ),
//             ),
//           ),
//         );
//       },
//     );
//   }
// }

import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../controllers/home_controller.dart';

class HomeView extends GetView<HomeController> {
  const HomeView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    var pressCount = 0;
    return GetBuilder<HomeController>(
      init: HomeController(),
      assignId: true,
      builder: (controller) {
        return WillPopScope(
          onWillPop: () async {
            pressCount++;
            if (pressCount == 2) {
              return true;
            } else {
              await Future.delayed(const Duration(seconds: 500)).then((value) async {
                if (pressCount != 2) {
                  Utils().showToast(message: AppStrings.exitAlertMessage);
                }
                await Future.delayed(const Duration(milliseconds: 3500)).then((value) {
                  pressCount = 0;
                });
              });
              return false;
            }
          },
          child: CommonScreen(
            isAppBar: true,
            isSafeArea: false,
            isLeading: false,
            isBackButton: false,
            title: AppStrings.inbox,
            textColor: AppColors.blackAppbar,
            body: Padding(
              padding: EdgeInsets.symmetric(horizontal: 20.w),
              child: Theme(
                data: ThemeData(primaryColor: AppColors.greenGradient1),
                child: SmartRefresher(
                  controller: controller.refreshController,
                  onRefresh: () async {
                    try {
                      controller.getMessageList();
                      controller.getAdminNotificationApi();
                      controller.refreshController.refreshCompleted();
                    } catch (e) {
                      controller.refreshController.refreshCompleted();
                    }
                  },
                  child: ListView(
                    shrinkWrap: true,
                    padding: EdgeInsets.zero,
                    physics: const BouncingScrollPhysics(),
                    children: [
                      controller.flagNotifies?.flagNotifies == null
                          ? Container(
                              height: 15.h,
                            )
                          : SizedBox(height: 10.h),
                      controller.flagNotifies?.flagNotifies == null
                          ? Container()
                          : ListView.builder(
                              shrinkWrap: true,
                              itemCount: controller.flagNotifies?.flagNotifies?.length,
                              physics: const NeverScrollableScrollPhysics(),
                              itemBuilder: (context, index) {
                                return CommonContainer(
                                  padding: EdgeInsets.symmetric(vertical: 14.h),
                                  isHeight: false,
                                  margin: EdgeInsets.only(bottom: 15.h),
                                  borderRadius: 10.r,
                                  isBorderRadius: true,
                                  bgImage: const DecorationImage(
                                      image: AssetImage(
                                        AppImages.icRedCard,
                                      ),
                                      fit: BoxFit.fill),
                                  alignment: Alignment.topRight,
                                  child: Row(
                                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Container(width: 40.w),
                                      Expanded(
                                        child: AppText(
                                          (controller.flagNotifies?.flagNotifies?[index].notifyMsg) ?? "",
                                          color: AppColors.greyBG,
                                          fontSize: 16.sp,
                                          textAlign: TextAlign.center,
                                          fontWeight: FontWeight.w400,
                                        ),
                                      ),
                                      GestureDetector(
                                        onTap: () {
                                          controller.readAdminNotificationApi(notificationId: controller.flagNotifies!.flagNotifies![index].mfId.toString(), index: index);
                                          controller.update();
                                        },
                                        child: Padding(
                                          padding: EdgeInsets.only(right: 10.w, left: 20.w),
                                          child: Icon(Icons.close, color: AppColors.greyBG, size: 24.w),
                                        ),
                                      )
                                    ],
                                  ),
                                );
                              }),
                      controller.messageList.isEmpty
                          ? Center(
                              child: Column(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  SizedBox(height: 300.h),
                                  AppText(
                                    AppStrings.noDataFound,
                                    color: AppColors.darkBlue700,
                                    fontFamily: FontFamily.montserratRegular,
                                    fontWeight: FontWeight.w500,
                                    fontSize: 20.sp,
                                  ),
                                ],
                              ),
                            )
                          : ListView.builder(
                              shrinkWrap: true,
                              padding: EdgeInsets.only(bottom: 10.h),
                              physics: const NeverScrollableScrollPhysics(),
                              itemCount: controller.messageList.length,
                              itemBuilder: (context, index) {
                                return GestureDetector(
                                  onTap: () {
                                    Get.toNamed(Routes.MESSAGE, arguments: [controller.messageList[index].fname, controller.messageList[index].userId, controller.messageList[index].isDelete])!.then(
                                      (value) {
                                        controller.messageList[index].unreadCount = "0";

                                        controller.update();
                                      },
                                    );

                                    printAction(controller.messageList[index].userId.toString());
                                  },
                                  child: CommonContainer(
                                    margin: EdgeInsets.only(bottom: 15.h),
                                    height: 77.h,
                                    borderRadius: 10.r,
                                    gradient: controller.messageList[index].unreadCount == "0"
                                        ? null
                                        : const LinearGradient(
                                            colors: [
                                              AppColors.greenGradient1,
                                              AppColors.greenGradient2,
                                              AppColors.greenGradient3,
                                            ],
                                          ),
                                    isBorderRadius: true,
                                    alignment: Alignment.topLeft,
                                    padding: EdgeInsets.only(left: 15.w),
                                    child: Column(
                                      crossAxisAlignment: CrossAxisAlignment.start,
                                      mainAxisAlignment: MainAxisAlignment.center,
                                      children: [
                                        AppText(
                                          controller.messageList[index].fname.toString(),
                                          color: controller.messageList[index].unreadCount != "0" ? AppColors.lightGreen : AppColors.darkBlueText,
                                          fontSize: 16.sp,
                                          fontWeight: FontWeight.w600,
                                        ),
                                        SizedBox(height: 8.h),
                                        AppText(
                                          controller.messageList[index].uniqueId.toString(),
                                          color: controller.messageList[index].unreadCount != "0" ? AppColors.greyBG : AppColors.darkBlue400,
                                          fontSize: 14.sp,
                                          fontWeight: FontWeight.w500,
                                        ),
                                      ],
                                    ),
                                  ),
                                );
                              },
                            ),
                    ],
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
