import '../../../helper/iphone_has_notch.dart';
import '../../../utils/all_imports.dart';
import '../../../widget/common_button.dart';
import '../../../widget/common_textfiled.dart';
import '../controllers/forgot_password_controller.dart';

class ForgotPasswordView extends GetView<ForgotPasswordController> {
  const ForgotPasswordView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<ForgotPasswordController>(
      init: ForgotPasswordController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isBackButton: true,
          isLeading: true,
          bottomBar: Padding(
            padding: EdgeInsets.only(bottom: (IphoneHasNotch.hasNotch) ? 25.h : 20.h),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                AppText(
                  AppStrings.doesNotHaveAnAccount,
                  color: AppColors.darkBlue400,
                  fontWeight: FontWeight.w500,
                  fontSize: 16.sp,
                ),
                const Text(" "),
                GestureDetector(
                  onTap: () {
                    Get.offAllNamed(Routes.LOGIN);
                  },
                  child: GradientAppText(
                    AppStrings.signIn,
                    fontWeight: FontWeight.w600,
                    fontSize: 16.sp,
                  ),
                ),
              ],
            ),
          ),
          isBottomBar: true,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              padding: EdgeInsets.only(top: 25.h),
              physics: const BouncingScrollPhysics(),
              children: [
                Image.asset(
                  AppImages.icLockImg,
                  width: 240.w,
                  height: 182.w,
                ),
                SizedBox(height: 60.h),
                GradientAppText(
                  AppStrings.forgetPassword,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                ),
                SizedBox(height: 30.h),
                AppText(
                  AppStrings.noWorries,
                  color: AppColors.darkBlue700,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.w500,
                  fontSize: 18.sp,
                ),
                SizedBox(height: 30.h),
                CommonTextFiled(
                  title: AppStrings.email,
                  prefixIcon: AppImages.email,
                  controller: controller.email,
                  hintText: AppStrings.enterEmail,
                  inputType: TextInputType.emailAddress,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp("[A-Z]")),
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                  textInputAction: TextInputAction.done,
                ),
                SizedBox(
                  height: 30.h,
                ),
                CommonButton(
                  buttonTitle: AppStrings.send,
                  onTap: () {
                    utils.hideKeyboard(context);
                    if (controller.email.text.trim().isEmpty) {
                      utils.showSnackBar(message: AppStrings.errorMessageEmailToSentCode);
                    } else if (!utils.emailValidator(controller.email.text.trim())) {
                      utils.showSnackBar(message: AppStrings.errorMessageValidEmail);
                      return false;
                    } else {
                      controller.sendOTP();
                    }
                  },
                ),
                SizedBox(height: 30.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
