import 'package:flutter/foundation.dart';
import 'package:voice_buddies/app/models/login_model.dart';
import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../utils/all_imports.dart';

class ForgotPasswordController extends BaseController {
  TextEditingController email = TextEditingController(text: (kDebugMode) ? "bhumit.kmphitech@gmail.com" : "");

  @override
  void onInit() {
    super.onInit();
  }

  /// Send OTP Api
  sendOTP() async {
    FormData formData = FormData.fromMap({
      "email": email.text,
    });

    final data = await APIFunction().apiCall(
      apiName: Constants.forgotPassword,
      params: formData,
    );

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      Get.toNamed(Routes.OTP, arguments: [false, "", "", email.text, "", "", "", "", "", "", "", "", ""]);
      email.clear();
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
