import 'package:just_audio/just_audio.dart';
import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_seekbar.dart';
import 'package:voice_buddies/app/widget/common_textfiled.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_container.dart';
import '../controllers/flag_controller.dart';

class FlagView extends GetView<FlagController> {
  const FlagView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<FlagController>(
      init: FlagController(),
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.flag,
          textColor: AppColors.blackAppbar,
          onTap: () async {
            await controller.player.stop();
            Get.back();
          },
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 25.h),
                AppText(
                  AppStrings.attachment,
                  color: AppColors.darkBlueText,
                  textAlign: TextAlign.start,
                  fontWeight: FontWeight.w500,
                  fontSize: 16.sp,
                ),
                SizedBox(height: 11.h),
                CommonContainer(
                  isBorderRadius: true,
                  borderRadius: 10.r,
                  isHeight: false,
                  padding: EdgeInsets.symmetric(vertical: 10.h),
                  child: Padding(
                    // padding: EdgeInsets.only(right: 14.w),
                    padding: EdgeInsets.only(right: 0.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                margin: EdgeInsets.zero,
                                padding: EdgeInsets.only(top: 4.h),
                                // height: 40.h,
                                width: double.infinity,
                                child: StreamBuilder<PositionData>(
                                  stream: controller.positionDataStream,
                                  builder: (context, snapshot) {
                                    final positionData = snapshot.data;
                                    return Padding(
                                      padding: EdgeInsets.only(left: 8.w, right: 8.w),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          AudioSeekBar(
                                            duration: positionData?.duration ?? Duration.zero,
                                            position: positionData?.position ?? Duration.zero,
                                            bufferedPosition: positionData?.bufferedPosition ?? Duration.zero,
                                            audioPlayer: controller.player,
                                            onChangeEnd: (newPosition) {
                                              controller.player.seek(newPosition);
                                            },
                                          ),
                                          Padding(
                                            padding: EdgeInsets.only(left: 5.w, top: 8.h),
                                            child: AppText(
                                              RegExp(r'((^0*[1-9]\d*:)?\d{2}:\d{2})\.\d+$').firstMatch("${positionData?.position ?? Duration.zero}")!.group(1)!,
                                              color: AppColors.darkBlue500,
                                              fontWeight: FontWeight.w400,
                                              textAlign: TextAlign.left,
                                              fontSize: 12.sp,
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ],
                          ),
                        ),
                        StreamBuilder<PlayerState>(
                            stream: controller.player.playerStateStream,
                            builder: (context, snapshot) {
                              return Padding(
                                padding: EdgeInsets.only(right: 10.w, top: 8.h, bottom: 8.h),
                                child: GestureDetector(
                                  onTap: () async {
                                    if (snapshot.data?.processingState == ProcessingState.completed) {
                                      controller.player.pause();
                                      controller.player.seek(Duration.zero);
                                    }
                                    controller.player.playing ? controller.player.pause() : controller.player.play();
                                    controller.update();
                                  },
                                  child: Image.asset(
                                    AppImages.icGreenPlay,
                                    height: 40.h,
                                    width: 40.w,
                                  ),
                                ),
                              );
                            }),
                      ],
                    ),
                  ),
                ),
                SizedBox(height: 20.h),
                AppText(
                  AppStrings.writeAMessage,
                  color: AppColors.darkBlueText,
                  textAlign: TextAlign.start,
                  fontWeight: FontWeight.w500,
                  fontSize: 16.sp,
                ),
                SizedBox(height: 10.h),
                CommonContainer(
                  color: AppColors.greyText,
                  padding: EdgeInsets.only(right: 10.w),
                  isHeight: false,
                  borderRadius: 10.r,
                  isBorderRadius: true,
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Padding(
                        padding: EdgeInsets.only(left: 15.w, right: 10.w, top: 23.h),
                        child: Image.asset(
                          AppImages.icMessage,
                          height: 24.h,
                          width: 24.w,
                        ),
                      ),
                      Expanded(
                        child: CommonMultiLineTextFiled(
                          controller: controller.message,
                          hintText: AppStrings.writeAMessage,
                          maxLines: 7,
                          isMaxLines: true,
                        ),
                      ),
                    ],
                  ),
                ),
                SizedBox(height: 30.h),
                CommonButton(
                  buttonTitle: AppStrings.done,
                  onTap: () {
                    if (controller.message.text.trim().isNotEmpty) {
                      controller.addFlagToMsgApi();
                    } else {
                      utils.showSnackBar(message: AppStrings.pleaseEnterMessage2, statusCode: 0);
                    }
                  },
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}

/// api done
// import 'package:just_audio/just_audio.dart';
// import 'package:voice_buddies/app/widget/common_button.dart';
// import 'package:voice_buddies/app/widget/common_textfiled.dart';
//
// import '../../../utils/all_imports.dart';
// import '../../../widget/common_container.dart';
// import '../../../widget/common_seekbar.dart';
// import '../controllers/flag_controller.dart';
//
// class FlagView extends GetView<FlagController> {
//   const FlagView({Key? key}) : super(key: key);
//   @override
//   Widget build(BuildContext context) {
//     return GetBuilder<FlagController>(
//       init: FlagController(),
//       assignId: true,
//       builder: (controller) {
//         return CommonScreen(
//           isAppBar: true,
//           isSafeArea: false,
//           isLeading: true,
//           isBackButton: true,
//           title: AppStrings.flag,
//           textColor: AppColors.blackAppbar,
//           body: Padding(
//             padding: EdgeInsets.symmetric(horizontal: 20.w),
//             child: ListView(
//               shrinkWrap: true,
//               physics: const BouncingScrollPhysics(),
//               children: [
//                 SizedBox(height: 25.h),
//                 AppText(
//                   AppStrings.attachment,
//                   color: AppColors.darkBlueText,
//                   textAlign: TextAlign.start,
//                   fontWeight: FontWeight.w500,
//                   fontSize: 16.sp,
//                 ),
//                 SizedBox(height: 11.h),
//                 CommonContainer(
//                   isBorderRadius: true,
//                   borderRadius: 10.r,
//                   isHeight: false,
//                   padding: EdgeInsets.symmetric(vertical: 10.h),
//                   child: Padding(
//                     // padding: EdgeInsets.only(right: 14.w),
//                     padding: EdgeInsets.only(right: 0.w),
//                     child: Row(
//                       mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                       crossAxisAlignment: CrossAxisAlignment.start,
//                       children: [
//                         Expanded(
//                           child: Column(
//                             crossAxisAlignment: CrossAxisAlignment.start,
//                             children: [
//                               Container(
//                                 margin: EdgeInsets.zero,
//                                 padding: EdgeInsets.only(top: 4.h),
//                                 // height: 40.h,
//                                 width: double.infinity,
//                                 child: StreamBuilder<PositionData>(
//                                   stream: controller.positionDataStream,
//                                   builder: (context, snapshot) {
//                                     final positionData = snapshot.data;
//
//                                     return Padding(
//                                       padding: EdgeInsets.only(left: 8.w, right: 8.w),
//                                       child: Column(
//                                         crossAxisAlignment: CrossAxisAlignment.start,
//                                         children: [
//                                           AudioSeekBar(
//                                             duration: positionData?.duration ?? Duration.zero,
//                                             position: positionData?.position ?? Duration.zero,
//                                             bufferedPosition: positionData?.bufferedPosition ?? Duration.zero,
//                                             audioPlayer: controller.player,
//                                             onChangeEnd: (newPosition) {
//                                               controller.player.seek(newPosition);
//                                             },
//                                           ),
//                                           Padding(
//                                             padding: EdgeInsets.only(left: 5.w, top: 8.h),
//                                             child: AppText(
//                                               RegExp(r'((^0*[1-9]\d*:)?\d{2}:\d{2})\.\d+$').firstMatch("${positionData?.position ?? Duration.zero}")!.group(1)!,
//                                               color: AppColors.darkBlue500,
//                                               fontWeight: FontWeight.w400,
//                                               textAlign: TextAlign.left,
//                                               fontSize: 12.sp,
//                                             ),
//                                           ),
//                                         ],
//                                       ),
//                                     );
//                                   },
//                                 ),
//                               ),
//                             ],
//                           ),
//                         ),
//                         StreamBuilder<PlayerState>(
//                             stream: controller.player.playerStateStream,
//                             builder: (context, snapshot) {
//
//                               return Padding(
//                                 padding: EdgeInsets.only(right: 10.w, top: 8.h, bottom: 8.h),
//                                 child: GestureDetector(
//                                   onTap: () async {
//                                     if (snapshot.data?.processingState == ProcessingState.completed) {
//                                       controller.player.pause();
//                                       controller.player.seek(Duration.zero);
//                                     }
//                                     controller.player.playing ? controller.player.pause() : controller.player.play();
//                                     controller.update();
//                                   },
//                                   child: Image.asset(
//                                     AppImages.icGreenPlay,
//                                     height: 40.h,
//                                     width: 40.w,
//                                   ),
//                                 ),
//                               );
//                             }),
//                       ],
//                     ),
//                   ),
//                 ),
//                 SizedBox(height: 20.h),
//                 AppText(
//                   AppStrings.writeAMessage,
//                   color: AppColors.darkBlueText,
//                   textAlign: TextAlign.start,
//                   fontWeight: FontWeight.w500,
//                   fontSize: 16.sp,
//                 ),
//                 SizedBox(height: 10.h),
//                 CommonContainer(
//                   color: AppColors.greyText,
//                   padding: EdgeInsets.only(right: 10.w),
//                   isHeight: false,
//                   borderRadius: 10.r,
//                   isBorderRadius: true,
//                   child: Row(
//                     crossAxisAlignment: CrossAxisAlignment.start,
//                     children: [
//                       Padding(
//                         padding: EdgeInsets.only(left: 15.w, right: 10.w, top: 23.h),
//                         child: Image.asset(
//                           AppImages.icMessage,
//                           height: 24.h,
//                           width: 24.w,
//                         ),
//                       ),
//                       Expanded(
//                         child: CommonMultiLineTextFiled(
//                           controller: controller.message,
//                           hintText: AppStrings.writeAMessage,
//                           maxLines: 7,
//                           isMaxLines: true,
//                         ),
//                       ),
//                     ],
//                   ),
//                 ),
//                 SizedBox(height: 30.h),
//                 CommonButton(
//                   buttonTitle: AppStrings.done,
//                   onTap: () {
//                     Helper().hideKeyboard(context);
//                     if (controller.message.text.isNotEmpty) {
//                       controller.addFlagToMsgApi();
//                     } else {
//                       Helper().showToast(message: AppStrings.pleaseEnterMessage, context: context);
//                     }
//                   },
//                 ),
//               ],
//             ),
//           ),
//         );
//       },
//     );
//   }
// }
