import 'package:just_audio/just_audio.dart';
import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_seekbar.dart';
import '../controllers/edit_profile_controller.dart';

class EditProfileView extends GetView<EditProfileController> {
  const EditProfileView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<EditProfileController>(
      init: EditProfileController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.editProfile,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              padding: EdgeInsets.zero,
              physics: const BouncingScrollPhysics(),
              children: [
                CommonContainer(
                  margin: EdgeInsets.only(top: 15.h),
                  height: 100.h,
                  bgImage: const DecorationImage(
                      image: AssetImage(
                        AppImages.icGreenCard,
                      ),
                      fit: BoxFit.fill),
                  borderRadius: 10.r,
                  isBorderRadius: true,
                  alignment: Alignment.topLeft,
                  padding: EdgeInsets.only(left: 20.w),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      AppText(
                        controller.loginData!.fname!,
                        color: AppColors.lightGreen,
                        fontSize: 22.sp,
                        fontWeight: FontWeight.bold,
                      ),
                      SizedBox(height: 8.h),
                      GradientAppText(
                        controller.loginData!.uniqueId!,
                        isGreenGradient: false,
                        fontSize: 18.sp,
                        fontWeight: FontWeight.w500,
                      ),
                    ],
                  ),
                ),
                SizedBox(height: 20.h),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    AppText(
                      AppStrings.aboutMe,
                      color: AppColors.darkBlueText,
                      fontSize: 18.sp,
                      fontWeight: FontWeight.w600,
                    ),
                    GestureDetector(
                      onTap: () async {
                        await controller.player.stop();
                        printAction("selectedLanguage.value missing currently iam ====>${controller.userDetails[3].details}");
                        Get.toNamed(Routes.USER_DETAILS, arguments: [
                          controller.loginData!.userId,
                          6,
                          false,
                          controller.loginData!.uniqueId,
                          controller.loginData!.fname,
                          controller.loginData!.email,
                          "",
                          controller.userDetails[2].details,
                          controller.userDetails[3].details,
                          controller.userDetails[4].details,
                          controller.userDetails[5].details,
                          controller.userDetails[6].details.removeAllWhitespace.split(","),
                          controller.userDetails[7].details,
                        ]);
                        printAction("language test  edit view=-=-=-=-=-=-=-=-=-=-=-=->>${controller.userDetails[4].details}");
                        printAction("language test  edit view=-=-=-=-=-=-=-=-=-=-=-=->>${controller.userDetails[4].details.split(",")}");
                      },
                      child: Image.asset(
                        AppImages.icEdit,
                        height: 18.h,
                        width: 18.w,
                      ),
                    )
                  ],
                ),
                SizedBox(height: 20.h),
                CommonContainer(
                  isBorderRadius: true,
                  borderRadius: 10.r,
                  isHeight: false,
                  padding: EdgeInsets.symmetric(vertical: 10.h),
                  child: Padding(
                    // padding: EdgeInsets.only(right: 14.w),
                    padding: EdgeInsets.only(right: 0.w),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                margin: EdgeInsets.zero,
                                padding: EdgeInsets.only(top: 4.h),
                                // height: 40.h,
                                width: double.infinity,
                                child: StreamBuilder<PositionData>(
                                  stream: controller.positionDataStream,
                                  builder: (context, snapshot) {
                                    final positionData = snapshot.data;
                                    return Padding(
                                      padding: EdgeInsets.only(left: 8.w, right: 8.w),
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          AudioSeekBar(
                                            duration: positionData?.duration ?? Duration.zero,
                                            position: positionData?.position ?? Duration.zero,
                                            bufferedPosition: positionData?.bufferedPosition ?? Duration.zero,
                                            audioPlayer: controller.player,
                                            onChangeEnd: (newPosition) {
                                              controller.player.seek(newPosition);
                                            },
                                          ),
                                          Padding(
                                            padding: EdgeInsets.only(left: 5.w, top: 8.h),
                                            child: AppText(
                                              RegExp(r'((^0*[1-9]\d*:)?\d{2}:\d{2})\.\d+$').firstMatch("${positionData?.position ?? Duration.zero}")!.group(1)!,
                                              color: AppColors.darkBlue500,
                                              fontWeight: FontWeight.w400,
                                              textAlign: TextAlign.left,
                                              fontSize: 12.sp,
                                            ),
                                          ),
                                        ],
                                      ),
                                    );
                                  },
                                ),
                              ),
                            ],
                          ),
                        ),
                        StreamBuilder<PlayerState>(
                            stream: controller.player.playerStateStream,
                            builder: (context, snapshot) {
                              return Padding(
                                padding: EdgeInsets.only(right: 10.w, top: 8.h, bottom: 8.h),
                                child: GestureDetector(
                                  onTap: () async {
                                    if (snapshot.data?.processingState == ProcessingState.completed) {
                                      controller.player.pause();
                                      controller.player.seek(Duration.zero);
                                    }
                                    controller.player.playerState.playing ? await controller.player.pause() : await controller.player.play();
                                    printAction("controller.player.playing==${controller.player.playerState.playing}");
                                    controller.update();
                                  },
                                  child: Image.asset(
                                    AppImages.icYellowPlay,
                                    height: 40.h,
                                    width: 40.w,
                                  ),
                                ),
                              );
                            }),
                      ],
                    ),
                  ),
                ),
                SizedBox(height: 20.h),
                AppText(
                  AppStrings.myDetails,
                  color: AppColors.darkBlueText,
                  fontSize: 18.sp,
                  fontWeight: FontWeight.w600,
                ),
                SizedBox(height: 5.h),
                ListView.builder(
                  shrinkWrap: true,
                  physics: const NeverScrollableScrollPhysics(),
                  itemCount: controller.userDetails.length - 1,
                  itemBuilder: (context, index) {
                    var userDetail = controller.userDetails[index];
                    return Padding(
                      padding: EdgeInsets.only(top: 10.h),
                      child: Column(
                        children: [
                          Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              AppText(
                                userDetail.name,
                                color: AppColors.darkBlue400,
                                fontSize: 16.sp,
                                fontWeight: FontWeight.w500,
                              ),
                              if (!(userDetail.name == AppStrings.email || userDetail.name == AppStrings.phoneNumber))
                                GestureDetector(
                                  onTap: () async {
                                    await controller.player.stop();
                                    printAction('controller.userDetails[3].details--------<<<<----->>>>>${controller.userDetails[3].details}');
                                    Get.toNamed(
                                      Routes.USER_DETAILS,
                                      arguments: [
                                        controller.loginData!.userId,
                                        index - 1,
                                        false,
                                        controller.loginData!.uniqueId,
                                        controller.loginData!.fname,
                                        controller.loginData!.email,
                                        "",
                                        controller.userDetails[2].details,
                                        controller.userDetails[3].details,
                                        controller.userDetails[4].details,
                                        controller.userDetails[5].details,
                                        controller.userDetails[6].details.removeAllWhitespace.split(","),
                                        controller.userDetails[7].details,
                                      ],
                                    );
                                  },
                                  child: Image.asset(
                                    AppImages.icEdit,
                                    height: 18.h,
                                    width: 18.w,
                                  ),
                                ),
                            ],
                          ),
                          SizedBox(height: 10.h),
                          CommonContainer(
                            isBorderRadius: true,
                            borderRadius: 10.r,
                            height: 50.h,
                            padding: EdgeInsets.symmetric(horizontal: 15.w),
                            isHeight: true,
                            alignment: Alignment.centerLeft,
                            child: AppText(
                              userDetail.details,
                              fontFamily: FontFamily.montserratRegular,
                              color: AppColors.darkBlueText,
                              fontSize: 16.sp,
                              fontWeight: FontWeight.w600,
                            ),
                          ),
                        ],
                      ),
                    );
                  },
                ),
                SizedBox(height: 15.h),
                GestureDetector(
                  onTap: () {
                    Get.toNamed(Routes.CHANGE_PASSWORD);
                  },
                  child: GradientAppText(
                    AppStrings.changePassword,
                    textAlign: TextAlign.center,
                    fontWeight: FontWeight.w600,
                    fontSize: 18.sp,
                    isGreenGradient: true,
                  ),
                ),
                SizedBox(height: 30.h),
                CommonButton(
                  buttonTitle: AppStrings.save,
                  onTap: () async {
                    utils.hideKeyboard(context);
                    controller.updateProfile();
                  },
                ),
                SizedBox(height: 25.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
