import 'package:voice_buddies/app/widget/common_button.dart';

import '../../../utils/all_imports.dart';
import '../controllers/delete_logout_confirmation_controller.dart';

class DeleteLogoutConfirmationView extends GetView<DeleteLogoutConfirmationController> {
  const DeleteLogoutConfirmationView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<DeleteLogoutConfirmationController>(
      init: DeleteLogoutConfirmationController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: false,
          isSafeArea: false,
          isLeading: true,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              Image.asset(
                controller.argument.value == AppStrings.delete ? AppImages.icDeleteImg : AppImages.icLogoutImg,
                width: 130.w,
                height: 130.w,
              ),
              SizedBox(height: 20.h),
              GradientAppText(
                controller.argument.value == AppStrings.delete ? AppStrings.deleteAccount : AppStrings.areYouLeaving,
                textAlign: TextAlign.center,
                fontWeight: FontWeight.bold,
                fontSize: 26.sp,
              ),
              SizedBox(height: 10.h),
              AppText(
                controller.argument.value == AppStrings.delete ? AppStrings.areYouSureYouWantToDeleteYourAccount : AppStrings.areYouSureWantToLogoutFromVoiceBuddies,
                height: 1.40.h,
                color: AppColors.darkBlue700,
                textAlign: TextAlign.center,
                fontWeight: FontWeight.w500,
                fontSize: 17.sp,
              ),
              SizedBox(
                height: 30.h,
              ),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: 20.w),
                child: Row(
                  children: [
                    Expanded(
                      child: GestureDetector(
                        onTap: () {
                          Get.back();
                        },
                        child: Container(
                          // padding: EdgeInsets.symmetric(vertical: 12.h),
                          width: double.infinity,
                          height: 50.h,
                          decoration: BoxDecoration(
                            color: AppColors.transparent,
                            borderRadius: BorderRadius.circular(10.r),
                            border: Border.all(color: AppColors.greenGradient3),
                            gradient: const LinearGradient(
                              colors: [
                                AppColors.greenGradient1,
                                AppColors.greenGradient2,
                                AppColors.greenGradient3,
                              ],
                            ),
                          ),
                          alignment: Alignment.center,
                          child: Center(
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                GradientAppText(
                                  AppStrings.no,
                                  textAlign: TextAlign.center,
                                  fontSize: 18.sp,
                                  maxLines: 1,
                                  fontWeight: FontWeight.w600,
                                  fontFamily: FontFamily.montserratSemiBold,
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ),
                    SizedBox(width: 20.w),
                    Expanded(
                      child: CommonButton(
                        buttonTitle: AppStrings.yes,
                        onTap: () {
                          controller.argument.value == AppStrings.delete ? controller.deleteAccountApi() : controller.logOutApi();
                          // controller.argument.value == AppStrings.delete ? Get.offAllNamed(Routes.LOGIN) : Get.offAllNamed(Routes.LOGIN);
                        },
                      ),
                    ),
                  ],
                ),
              ),
              SizedBox(height: 25.h),
            ],
          ),
        );
      },
    );
  }
}
