import 'package:voice_buddies/app/models/login_model.dart';
import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../utils/all_imports.dart';

class DeleteLogoutConfirmationController extends BaseController {
  RxString argument = "".obs;
  RxString deleteReason = "".obs;
  @override
  void onInit() {
    getUserData();
    if (Get.arguments != null) {
      argument.value = Get.arguments[0];
      if (Get.arguments.length == 2) {
        deleteReason.value = Get.arguments[1];
        printAction("deleteReason.value=${deleteReason.value}");
      }
    }
    super.onInit();
  }

  ///  logOutApi
  logOutApi() async {
    FormData formData = FormData.fromMap({
      "user_id": loginData?.userId,
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.logOut,
      params: formData,
      token: loginData?.token,
    );
    LoginDataModel model = LoginDataModel.fromJson(data);
    if (model.responseCode == 1) {
      await getStorageData.removeData(getStorageData.loginData);
      utils.showToast(message: model.responseMsg!);
      Get.offAllNamed(Routes.LOGIN);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }

  ///  deleteAccountApi
  deleteAccountApi() async {
    FormData formData = FormData.fromMap({
      "user_id": loginData?.userId,
      "reason": deleteReason.value,
    });
    final data = await APIFunction().apiCall(
      apiName: Constants.deleteAccount,
      params: formData,
      token: loginData?.token,
    );
    LoginDataModel model = LoginDataModel.fromJson(data);
    if (model.responseCode == 1) {
      await getStorageData.removeData(getStorageData.loginData);
      utils.showToast(message: model.responseMsg!);
      Get.offAllNamed(Routes.LOGIN);
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
