import '../../../utils/all_imports.dart';
import '../../../widget/common_button.dart';
import '../../../widget/common_textfiled.dart';
import '../controllers/create_new_password_controller.dart';

class CreateNewPasswordView extends GetView<CreateNewPasswordController> {
  const CreateNewPasswordView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<CreateNewPasswordController>(
      init: CreateNewPasswordController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              padding: EdgeInsets.only(top: 25.h),
              physics: const BouncingScrollPhysics(),
              children: [
                Image.asset(
                  AppImages.icLockImg,
                  width: 240.w,
                  height: 182.w,
                ),
                SizedBox(height: 60.h),
                GradientAppText(
                  AppStrings.setNewPassword,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.bold,
                  fontSize: 26.sp,
                ),
                SizedBox(height: 10.h),
                AppText(
                  AppStrings.mustBeEight,
                  color: AppColors.darkBlue700,
                  textAlign: TextAlign.center,
                  fontWeight: FontWeight.w500,
                  fontSize: 18.sp,
                ),
                SizedBox(height: 30.h),
                CommonTextFiled(
                  title: AppStrings.newPassword,
                  prefixIcon: AppImages.password,
                  controller: controller.newPassword,
                  hintText: AppStrings.enterNewPassword,
                  obscureText: false,
                  suffixVisibility: true,
                  enableInteractiveSelection: false,
                  isMaxLines: true,
                  maxLines: 1,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.confirmPassword,
                  prefixIcon: AppImages.password,
                  controller: controller.confirmPassword,
                  hintText: AppStrings.enterConfirmPassword,
                  suffixVisibility: true,
                  enableInteractiveSelection: false,
                  obscureText: false,
                  isMaxLines: true,
                  maxLines: 1,
                  inputFormat: [
                    FilteringTextInputFormatter.deny(RegExp(r'\s')),
                  ],
                  textInputAction: TextInputAction.done,
                ),
                SizedBox(
                  height: 30.h,
                ),
                CommonButton(
                  buttonTitle: AppStrings.resetPassword,
                  onTap: () {
                    if (controller.isValidation()) {
                      controller.updatePasswordApi();
                    }
                  },
                ),
                SizedBox(height: 25.h),
              ],
            ),
          ),
        );
      },
    );
  }
}
