import 'package:voice_buddies/app/widget/common_button.dart';
import 'package:voice_buddies/app/widget/common_container.dart';

import '../../../utils/all_imports.dart';
import '../../../widget/common_textfiled.dart';
import '../controllers/contact_us_controller.dart';

class ContactUsView extends GetView<ContactUsController> {
  const ContactUsView({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return GetBuilder<ContactUsController>(
      init: ContactUsController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: true,
          isSafeArea: false,
          isLeading: true,
          isBackButton: true,
          title: AppStrings.contactUs,
          textColor: AppColors.blackAppbar,
          body: Padding(
            padding: EdgeInsets.symmetric(horizontal: 20.w),
            child: ListView(
              shrinkWrap: true,
              physics: const BouncingScrollPhysics(),
              children: [
                SizedBox(height: 10.h),
                CommonTextFiled(
                  title: AppStrings.name,
                  controller: controller.name,
                  enabled: false,
                  hintText: AppStrings.enterName,
                  prefixIcon: AppImages.icName,
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.email,
                  enabled: false,
                  controller: controller.email,
                  hintText: AppStrings.enterEmail,
                  prefixIcon: AppImages.email,
                ),
                SizedBox(height: 20.h),
                CommonTextFiled(
                  title: AppStrings.subject,
                  controller: controller.subject,
                  hintText: AppStrings.enterSubject,
                  prefixIcon: AppImages.icSubject,
                ),
                SizedBox(height: 20.h),
                AppText(
                  AppStrings.message,
                  color: AppColors.darkBlueText,
                  textAlign: TextAlign.start,
                  fontWeight: FontWeight.w600,
                  fontSize: 16.sp,
                ),
                SizedBox(height: 10.h),
                CommonContainer(
                  color: AppColors.greyText,
                  padding: EdgeInsets.only(right: 10.w),
                  isHeight: false,
                  borderRadius: 10.r,
                  isBorderRadius: true,
                  child: Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Padding(
                        padding: EdgeInsets.only(left: 15.w, right: 10.w, top: 23.h),
                        child: Image.asset(
                          AppImages.icMessage,
                          height: 24.h,
                          width: 24.w,
                        ),
                      ),
                      Expanded(
                        child: CommonMultiLineTextFiled(
                          controller: controller.message,
                          hintText: AppStrings.enterMessage,
                          maxLines: 4,
                          isMaxLines: true,
                          textInputAction: TextInputAction.done,
                        ),
                      ),
                    ],
                  ),
                ),
                SizedBox(height: 30.h),
                CommonButton(
                  buttonTitle: AppStrings.submit,
                  onTap: () {
                    if (controller.isValidation()) {
                      controller.contactUsApi();
                    }
                  },
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
