import 'package:flutter/foundation.dart';
import 'package:voice_buddies/app/models/login_model.dart';
import 'package:voice_buddies/app/widget/base_controller.dart';

import '../../../utils/all_imports.dart';

class ChangePasswordController extends BaseController {
  TextEditingController currentPassword = TextEditingController(text: (kDebugMode) ? "Bhumit@123" : "");
  TextEditingController newPassword = TextEditingController(text: (kDebugMode) ? "Bhumit@1234" : "");
  TextEditingController confirmPassword = TextEditingController(text: (kDebugMode) ? "Bhumit@1234" : "");

  @override
  void onInit() {
    getUserData();
    super.onInit();
  }

  /// validation
  bool isValidation() {
    if (utils.isValidationEmpty(currentPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageCurrentPassword);
      return false;
    } else if (utils.isValidationEmpty(newPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageNewPassword);
      return false;
    } else if (!utils.passwordValidator(newPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageNewValidPassword);
      return false;
    } else if (utils.isValidationEmpty(confirmPassword.text.trim())) {
      utils.showSnackBar(message: AppStrings.errorMessageConfirmPassword);
      return false;
    } else if (newPassword.text.trim() != confirmPassword.text.trim()) {
      utils.showSnackBar(message: AppStrings.errorMessageNotMatchPass);
      return false;
    }

    return true;
  }

  ///Change Password Api
  changePasswordApi() async {
    FormData formData = FormData.fromMap({
      "user_id": loginData!.userId,
      "old_password": utils.generateMd5(currentPassword.text),
      "new_password": utils.generateMd5(newPassword.text),
    });

    final data = await APIFunction().apiCall(apiName: Constants.changePassword, params: formData, token: loginData!.token!);

    LoginDataModel model = LoginDataModel.fromJson(data);

    if (model.responseCode == 1) {
      Get.toNamed(Routes.DONE, arguments: AppStrings.changePassword);
      confirmPassword.clear();
      newPassword.clear();
      currentPassword.clear();
    } else {
      utils.showSnackBar(message: model.responseMsg!, statusCode: model.responseCode);
    }
  }
}
