import '../../../utils/all_imports.dart';
import '../controllers/splash_controller.dart';

class SplashView extends GetView<SplashController> {
  const SplashView({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return GetBuilder<SplashController>(
      init: SplashController(),
      assignId: true,
      builder: (controller) {
        return CommonScreen(
          isAppBar: false,
          isSafeArea: false,
          bgImage: AppImages.splashBg,
          child: Center(
            child: Padding(
              padding: EdgeInsets.only(right: 70.w),
              child: Image.asset(
                AppImages.appLogoTransparent,
                width: 266.w,
                height: 144.h,
              ),
            ),
          ),
        );
      },
    );
  }
}
