# Reporting Security Issues

We at Snyk value the security community and believe that responsible disclosure of security vulnerabilities in open source packages helps us ensure the security and privacy of the users.

If you believe you have found a security vulnerability on Snyk, we encourage you to let us know right away. We will investigate all legitimate reports and do our best to quickly fix the problem. Before reporting though, please review our responsible disclosure policy, and those things that should not be reported.

Submit your report to security@snyk.io (one issue per report) and respond to the report with any updates. Please do not contact employees directly or through other channels about a report.

Report security bugs in third-party modules to the person or team maintaining the module. You can also report a vulnerability through our [Snyk Vulnerability Disclosure](https://snyk.io/vulnerability-disclosure/) program.

### Responsible Disclosure Policy

We ask that:

- You give us reasonable time to investigate and mitigate an issue you report before making public any information about the report or sharing such information with others.
- You do not interact with an individual account (which includes modifying or accessing data from the account) if the account owner has not consented to such actions.
- You make a good faith effort to avoid privacy violations and disruptions to others, including (but not limited to) destruction of data and interruption or degradation of our services.
- You do not exploit a security issue you discover for any reason. (This includes demonstrating additional risk, such as attempted compromise of sensitive company data or probing for additional issues).
- You do not violate any other applicable laws or regulations.

Find out more about our [Bug Bounty program](https://docs.snyk.io/more-info/disclosing-vulnerabilities/disclose-a-vulnerability-in-snyk-services)
