import { Context, DynamicSamplingContext, MeasurementUnit, Transaction as TransactionInterface, TransactionContext, TransactionEvent, TransactionMetadata } from '@sentry/types';
import { Hub } from '../hub';
import { Span as SpanClass } from './span';
/** JSDoc */
export declare class Transaction extends SpanClass implements TransactionInterface {
    metadata: TransactionMetadata;
    /**
     * The reference to the current hub.
     */
    _hub: Hub;
    private _name;
    private _measurements;
    private _contexts;
    private _trimEnd?;
    private _frozenDynamicSamplingContext;
    /**
     * This constructor should never be called manually. Those instrumenting tracing should use
     * `Sentry.startTransaction()`, and internal methods should use `hub.startTransaction()`.
     * @internal
     * @hideconstructor
     * @hidden
     */
    constructor(transactionContext: TransactionContext, hub?: Hub);
    /*Getter for `name` property
    Setter for `name` property, which also sets `source` as custom */
    name: string;
    /**
     * JSDoc
     */
    setName(name: string, source?: TransactionMetadata['source']): void;
    /**
     * Attaches SpanRecorder to the span itself
     * @param maxlen maximum number of spans that can be recorded
     */
    initSpanRecorder(maxlen?: number): void;
    /**
     * @inheritDoc
     */
    setContext(key: string, context: Context | null): void;
    /**
     * @inheritDoc
     */
    setMeasurement(name: string, value: number, unit?: MeasurementUnit): void;
    /**
     * @inheritDoc
     */
    setMetadata(newMetadata: Partial<TransactionMetadata>): void;
    /**
     * @inheritDoc
     */
    finish(endTimestamp?: number): string | undefined;
    /**
     * @inheritDoc
     */
    toContext(): TransactionContext;
    /**
     * @inheritDoc
     */
    updateWithContext(transactionContext: TransactionContext): this;
    /**
     * @inheritdoc
     *
     * @experimental
     */
    getDynamicSamplingContext(): Readonly<Partial<DynamicSamplingContext>>;
    /**
     * Override the current hub with a new one.
     * Used if you want another hub to finish the transaction.
     *
     * @internal
     */
    setHub(hub: Hub): void;
    /**
     * Finish the transaction & prepare the event to send to Sentry.
     */
    protected _finishTransaction(endTimestamp?: number): TransactionEvent | undefined;
}
//# sourceMappingURL=transaction.d.ts.map
