<?php

use App\Http\Controllers\Api\FeatureApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['middleware' => 'request.key'], function(){
    Route::post('getVoiceBuddiesID', [UserApiController::class, 'getVoiceBuddiesID']);
    Route::post('sendOtp',[UserApiController::class, 'sendOtp']);
    Route::post('signUp',[ UserApiController::class, 'signUp']);

    Route::post('login',[ UserApiController::class, 'login']);
    Route::post('forgotPassword', [UserApiController::class, 'forgotPassword']);
    Route::post('verifyOtp', [UserApiController::class, 'verifyOtp']);
    Route::post('updatePassword', [UserApiController::class, 'updatePassword']);
    Route::post('checkEmail', [UserApiController::class, 'checkEmail']);

    Route::post('sendOTPPhone', [UserApiController::class, 'sendOTPPhone']);
    Route::post('forgotPasswordPhone', [UserApiController::class, 'forgotPasswordPhone']);
    Route::post('verifyForgotPasswordOTPPhone', [UserApiController::class, 'verifyForgotPasswordOTPPhone']);
    Route::post('updatePasswordPhone', [UserApiController::class, 'updatePasswordPhone']);

});
Route::group(['middleware' => 'request.keyToken'], function(){
    Route::post('logOut', [UserApiController::class, 'logOut']);
    Route::post('getUserProfile', [UserApiController::class, 'getUserProfile']);
    Route::post('updateProfile', [UserApiController::class, 'updateProfile']);
    Route::post('changePassword', [UserApiController::class, 'changePassword']);
    Route::post('contactUs', [UserApiController::class, 'contactUs']);
    Route::post('deleteAccount', [UserApiController::class, 'deleteAccount']);

    Route::post('searchPage', [FeatureApiController::class, 'searchPage']);
    Route::post('blockUnBlockUser', [FeatureApiController::class, 'blockUnBlockUser']);
    Route::post('getBlockUsers', [FeatureApiController::class, 'getBlockUsers']);

    Route::post('sendChatMedia', [FeatureApiController::class, 'sendChatMedia']);
    Route::post('addFlagToMsg', [FeatureApiController::class, 'addFlagToMsg']);
    Route::post('getAdminNotification', [FeatureApiController::class, 'getAdminNotification']);
    Route::post('readAdminNotification', [FeatureApiController::class, 'readAdminNotification']);
    Route::post('msgDelete', [FeatureApiController::class, 'msgDelete']);
});

