<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User_Master extends Authenticatable
{
    public $table = 'user_master';

    protected $primaryKey = 'user_id';

    //gender: 'male','female','other','decline'
    protected $fillable = [
        'user_id', 'fname', 'email', 'gender', 'age', 'i_am', 'i_live', 'spoken', 'voice', 'unique_id', 'pass',
        'created_at', 'updated_at', 'is_delete', 'device_type', 'device_token','delete_reason','is_verify','ccode','phone'
    ];

    protected $hidden = [
        'pass',
        'created_at',
        'updated_at',
        'device_type',
        'device_token',
        'is_delete',
        'delete_reason',
    ];

    protected $casts = [
        'user_id' => 'integer',
        'is_verify' => 'string',
    ];

    protected static function booted()
    {
        static::addGlobalScope('soft_delete', function (Builder $builder) {
            $builder->where('is_delete', 0);
        });
    }

    public function getVoiceAttribute($key)
    {
        return $key ? env('PUBLIC_PATH').'voices/'.$key : '';
    }
}
