<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Notification_Master extends Model
{
    public $table = 'notification_master';

    protected $primaryKey = 'notify_id';

    protected $fillable = [
        'user_by', 'user_to', 'model_id', 'model_name',
    ];
    
    protected $hidden = ['updated_at'];
    
    public function getCreatedAtAttribute($val)
    {
        return Carbon::parse($val)->toDateTimeString();
    }
}
