<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Msg_Flag_Master extends Model
{
    public $table = 'msg_flag_master';

    protected $primaryKey = 'mf_id';

    protected $fillable = [
        'user_by', 'msg_id', 'msg_user_id', 'notes','notify_msg','notify_read'
    ];
    
    public function msg(){
        return $this->belongsTo(Message_Master::class,'msg_id','msg_id');
    }
    public function userBy()
    {
        return $this->belongsTo(User_Master::class,'user_by','user_id');
    }
    public function msgUser()
    {
        return $this->belongsTo(User_Master::class,'msg_user_id','user_id');
    }
    
}
