<?php

namespace App\Http\Middleware;

use App\Http\Controllers\AppBaseController;
use App\Http\Controllers\CommonController;
use Closure;
use Illuminate\Http\Request;

class RequestKey extends AppBaseController
{
    /**
     * @param Request $request
     * @param Closure $next
     *
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $key = $request->header('key');
        $valid = $this->requiredValidation([
            'key' => $key,
        ]);
        if (!empty($valid)) {
            $msg = trans('words.please_enter') . $valid;

            return $this->responseError(0, $msg);
        }

        if (CommonController::checkKeyExist($key) == 0) {
            return $this->responseError(0, __('words.incorrect_key'));
        }

        $request->request->add(['key' => $key]);

        return $next($request);
    }
}
