<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User_Master;
use App\Http\Controllers\AppBaseController;
use Laracasts\Flash\Flash;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $users = User_Master::select("*")->orderBy('user_id', 'desc')->get();
        // dd($users->toArray());
        return view('admin.user.index', compact('users'))
            ->with('i', (request()->input('page', 1) - 1) * 5);
    }

    public function verifyUserAccount(Request $request)
    {
        // $partner = User_Master::where(['user_id' => $request->user_id])->first();
        User_Master::where('user_id', $request->user_id)->update(['is_verify' => 1]);
        Flash::success("User verify successfully.");
    }
    
}
